	TITLE	'CP/M SECRTARY WORD PROCESSOR 820220A'
;COPYRIGHT 1979, G. YOUNG, PO BOX 3218, NORTH HOLLYWOOD, CA 91609
;PERMISSION GRANTED TO COPY FOR NON-COMMERCIAL USE ONLY


; A NOTE ABOUT THIS CODE:  ORIGINALLY SECRETARY WAS ONLY AVAILABLE ON
; NORTH STAR SYSTEMS.  THE CODE WAS COMPOSED OF 5 FILES AND EACH FILE
; HAD TO FIT IN MEMORY DUE TO AN OLD EDITOR THAT WAS USED EDIT IT.
; CONSEQUENTLY, TO SAVE MEMORY IN EACH FILE, NO COMMENTS WERE ADDED.
; THIS IS WHY THE ONLY COMMENTS ARE ON THE NEW CODE SPECIFIC TO CP/M.
;
;
	ORG	100H
INIT	JMP	INITA
ASSEMBLED	DB	' 820320A$'
	DB	'COPYRIGHT 1979, G.YOUNG, INC'
BSPCH	DB	08
STOP	DB	0
SRCNT	DB	23
FLG1	DB	'N'
BSCR	DB	'C'
LNSIZ	DB	80
WRAP	DB	'Y'
BOOT	EQU	0000H
DOS	EQU	BOOT
BDOS	EQU	0005H
PRINTER	EQU	5
CONSOLE	EQU	2
CLEAN	LXI	H,BOFP
	MVI	C,255
	XRA	A
CLRM	MOV	M,A
	INX	H
	DCR	C
	JNZ	CLRM
	LXI	H,DATA
	SHLD	BOFP
	SHLD	EOFP
	LHLD	BDOS+1
	SHLD	TOP
	MVI	A,CONSOLE
	STA	UNIT
	MVI	A,70
	STA	LINES
	MVI	A,1
	LHLD	BOFP
	MOV	M,A
	MVI	A,66
	STA	PAGE1
	MVI	A,54
	STA	PAGE2
	MVI	A,7
	STA	PAGE3
	LDA	BSPCH
	STA	X5F2+1
	STA	X5F1+1
	STA	X5F3+1
	LDA	LNSIZ
	STA	CPI80+1
	SUI	7
	STA	CPI74+1
	RET
INITA	LXI	SP,AREA+50
	CALL	CLEAN
	CALL	CRLF
	LXI	SP,AREA+50
	LXI	D,SMESS
	CALL	SCRN
	LXI	D,ASSEMBLED
	CALL	SCRN
	LXI	SP,AREA+50
	CALL	FREE1
	LDA	FLG1
	CPI	'Y'
	JNZ	CONFIGURE
EOR	LXI	SP,AREA+50
	CALL	CRLF
	MVI	B,'#'
	CALL	OUT8
	CALL	READ
	LXI	H,IBUF
	MOV	A,M
	CPI	'0'
	CC	CMPCT
	CPI	'9'+1
	JC	LINER
	XRA	A
	STA	AUTO
	CALL	VALC
	CALL	COMM
	JMP	EOR
CMPCT	LDA	DBFLG
	ORA	A
	JNZ	DUMP4
	LXI	D,IBUF+1
L1	LDAX	D
	MOV	M,A
	CPI	13
	JZ	L2
	INX	D
	INX	H
	JMP	L1
L2	LXI	H,IBUF
	LDA	IBUF-1
	DCR	A
	STA	IBUF-1
	MOV	A,M
	RET
READ	LXI	H,IBUF
	LXI	D,TBUF
	XRA	A
	STA	HALT
	STA	TEMP
	LDA	AUTO
	ORA	A
	JZ	BACKN
	CALL	LNGEN
	MVI	C,6
	LXI	D,TBUF+4
	JMP	INPUT
RESTR	LXI	H,IBUF
RESCN	LXI	D,TBUF
	XRA	A
	STA	TEMP
BACKN	MVI	C,2
INPUT	CALL	IN8
	CPI	0
	JZ	INPUT
	CPI	2
	JZ	INPUT
	CPI	0AH
	JZ	INPUT
	CPI	07
	JZ	CPYLN
	CPI	18H		;CNTLX
	JZ	EOR
X5F1	CPI	08H
	JZ	BACKS
	CPI	011H
	JZ	BACKS
	CPI	0FH
	JZ	BACKS
	CPI	01H
	JZ	CPYCH1
	CPI	04
	JZ	FNDCH
	CPI	19H
	JZ	PUTIN
	CPI	13
	JZ	EDONE
	CPI	0EH
	JZ	CNTLN
	CPI	010H
	JZ	RESTR
	CPI	40H
	JZ	CNTLN
	CPI	1AH
	JZ	DELCH
	CPI	03H
	JZ	CLR1
	JMP	CHAR
CLR1	XRA	A
	STA	AUTO
	JMP	EOR
BACKS	MOV	A,C
	CPI	2
	JC	INPUT
	JZ	INPUT
	DCR	C
	DCX	H
	DCX	D
X5F2	MVI	B,08
	CALL	OUT8
	JMP	INPUT
DELCH	LDAX	D
	CPI	13
	JZ	INPUT
	INX	D
	MVI	B,'%'
	CALL	OUT8
	JMP	INPUT
CPYCH1	LDAX	D
	CPI	13
	JZ	INPUT
	MOV	A,C
	CPI	139
	JZ	BELL
	LDAX	D
	MOV	M,A
	MOV	B,A
	CALL	OUT8
	INR	C
	INX	H
	INX	D
	JMP	INPUT
CPYLN	LDAX	D
	CPI	13
	JZ	INPUT
	MOV	A,C
	CPI	139
	JZ	BELL
	LDAX	D
	MOV	B,A
	MOV	M,A
	CALL	OUT8
	INX	D
	INX	H
	INR	C
	JMP	CPYLN
BELL	MVI	B,07
	CALL	OUT8
	JMP	INPUT
PUTIN	LDA	TEMP
	ORA	A
	JZ	SETON
	MVI	B,'>'
	CALL	OUT8
	XRA	A
	STA	TEMP
	JMP	INPUT
SETON	MVI	B,'<'
	CALL	OUT8
	MVI	A,1
	STA	TEMP
	JMP	INPUT
FNDCH	CALL	IN8
	CPI	03
	JZ	EOR
	PUSH	D
	INX	D
	MOV	B,A
FND2	LDAX	D
	CMP	B
	JZ	FND3
	CPI	13
	JZ	FND5
	INX	D
	JMP	FND2
FND3	POP	D
	MOV	B,A
	CALL	DUP1
FND4	LDAX	D
	CMP	B
	JZ	INPUT
	MOV	A,C
	CPI	139
	JZ	INPUT
	CALL	DUP1
	JMP	FND4
DUP1	LDAX	D
	MOV	M,A
	PUSH	B
	MOV	B,A
	CALL	OUT8
	POP	B
	INR	C
	INX	H
	INX	D
	RET
FND5	POP	D
	MVI	B,07
	CALL	OUT8
	JMP	FNDCH
CNTLN	MVI	B,'@'
	CALL	OUT8
	MVI	A,13
	MOV	M,A
	CALL	CRLF
	CALL	COPY
	JMP	RESTR
COPY	PUSH	D
	PUSH	H
	LXI	D,IBUF
	LXI	H,TBUF
CPYN	LDAX	D
	MOV	M,A
	CPI	13
	JZ	CPYX
	INX	D
	INX	H
	JMP	CPYN
CPYX	POP	H
	POP	D
	RET
EDONE	MOV	A,C
	CPI	2
	JZ	READ
	CPI	10
	JC	NOBU1
BKUP1	DCX	H
	DCR	C
	MOV	A,M
	CPI	' '
	JZ	BKUP1
	INX	H
	INR	C
NOBU1	MVI	M,13
	INX	H
	MVI	M,1
	LXI	H,IBUF-1
	MOV	M,C
	CALL	COPY
	LDA	HALT
	ORA	A
	RZ
	CALL	LINE
	JMP	EOR
CHAR	MOV	B,A
	LDA	TEMP
	ORA	A
	JNZ	CHAR1
	MOV	A,C
CPI80	CPI	66
	JNZ	CHAR1
	MOV	A,B
	STA	TEMP3
	LDA	WRAP
	CPI	'N'
	JZ	WRAP1
	LDA	AUTO
	ORA	A
	JNZ	WRAP2
WRAP1	MVI	B,07
	CALL	OUT8
	JMP	INPUT
WRAP2	MVI	M,13
	DCX	H
WRAP3	DCX	H
	MOV	A,M
	CPI	' '
	JNZ	WRAP3
WRAP6	DCX	H
	MOV	A,M
	CPI	' '
	JZ	WRAP6
	INX	H
	SHLD	ADDR1
	MVI	A,13
	MOV	M,A
	INX	H
	MOV	A,M
	STA	TEMP2+1
	MVI	A,1
	MOV	M,A
	LXI	H,IBUF
	MVI	C,2
WRAP7	MOV	A,M
	CPI	13
	JZ	WRAP8
	INR	C
	INX	H
	JMP	WRAP7
WRAP8	MOV	A,C
	STA	IBUF-1
	CALL	COPY
	CALL	LINE
	CALL	CRLF
	LXI	H,IBUF
	MVI	B,'#'
	CALL	OUT8
	CALL	LNGEN
	MVI	C,6
	XCHG
	LHLD	ADDR1
	XCHG
	INX	D
	LDA	TEMP2+1
	CPI	' '
	JZ	WRAP4
	MOV	M,A
	MOV	B,A
	INR	C
	CALL	OUT8
	INX	H
WRAP4	INX	D
	LDAX	D
	CPI	13
	JZ	WRAP5
	MOV	M,A
	INX	H
	INR	C
	MOV	B,A
	CALL	OUT8
	JMP	WRAP4
WRAP5	LXI	D,TBUF-2
	PUSH	H
	MVI	H,0
	MOV	L,C
	DAD	D
	XCHG
	POP	H
	LDA	TEMP3
	MOV	B,A
CHAR1	MOV	M,B
	INR	C
	CALL	OUT8
	MOV	A,C
CPI74	CPI	59
	JNZ	NOBEL
	MVI	B,07
	CALL	OUT8
NOBEL	INX	H
	LDA	TEMP
	ORA	A
	JNZ	INPUT
	INX	D
	JMP	INPUT
COMM	LXI	D,IBUF
	MVI	B,4
UPPER1	LDAX	D
	CPI	60H
	JC	LOWER1
	SBI	20H
	STAX	D
LOWER1	INX	D
	DCR	B
	JNZ	UPPER1
	LXI	D,CTAB
	MVI	B,NCOM
	MVI	A,4
	STA	NCHR
	CALL	COMS
	JNZ	ERR1
	PCHL
COMS	LXI	H,IBUF
	MVI	A,3		;COMPARE ONLY FIRST THREE
	MOV	C,A
	CALL	SEAR
	INX	D		;POSITION PAST 4TH CHAR
	LDAX	D
	MOV	L,A
	INX	D
	LDAX	D
	MOV	H,A
	RZ
	INX	D
	DCR	B
	JNZ	COMS
	INR	B
	RET
SEAR	LDAX	D
	CMP	M
	JNZ	INCA
	INX	H
	INX	D
	DCR	C
	JNZ	SEAR
	RET
INCA	INX	D
	DCR	C
	JNZ	INCA
	INR	C
	RET
ZBUF	XRA	A
	LXI	D,ABUF+12
	MVI	B,12
ZBU1	DCX	D
	STAX	D
	DCR	B
	JNZ	ZBU1
	RET
VALC	EQU	$
ETRA	LXI	H,0
	SHLD	BBUF+2
	SHLD	FBUF
	CALL	ZBUF
	LXI	H,IBUF-1
VAL1	INX	H
	MOV	A,M
	CPI	' '
	CMC
	RNC
	JNZ	VAL1
	SHLD	PNTR
	CALL	SBLK
	CMC
	RNC
VAL5	LXI	D,ABUF
	CALL	ALPS
	MOV	A,B
	CPI	5
	CMC
	RC
	LXI	B,ABUF
	CALL	AHEX
	RC
	SHLD	BBUF
	LXI	H,ABUF
	CALL	NORM
	CALL	SBLK
	CMC
	RNC
	LXI	D,ABUF+4
	CALL	ALPS
	MOV	A,B
	CPI	5
	CMC
	RC
	LXI	B,ABUF+4
	CALL	AHEX
	RC
	SHLD	BBUF+2
	LXI	H,ABUF+4
	CALL	NORM
	CALL	SBLK
	CMC
	RNC
	LXI	D,ABUF+8
	CALL	ALPS
	MOV	A,B
	CPI	5
	CMC
	RC
	LXI	H,ABUF+8
	CALL	NORM
	ORA	A
	RET
RANGE	PUSH	H
	PUSH	D
	LDA	ABUF+4
	ORA	A
	JZ	OK
	MVI	B,4
	LXI	H,ABUF
	LXI	D,ABUF+4
CKIT	LDAX	D
	CMP	M
	JC	ERR2
	JNZ	OK
	INX	H
	INX	D
	DCR	B
	JZ	OK
	JMP	CKIT
OK	POP	D
	POP	H
	RET
AHEX	LXI	H,0
AHE1	LDAX	B
	ORA	A
	RZ
	DAD	H
	DAD	H
	DAD	H
	DAD	H
	CALL	AHS1
	CPI	10H
	CMC
	RC
	ADD	L
	MOV	L,A
	INX	B
	JMP	AHE1
AHS1	SUI	48
	CPI	10
	RC
	SUI	7
	RET
ADEC	LXI	H,0
ADE1	LDAX	B
	ORA	A
	RZ
	MOV	D,H
	MOV	E,L
	DAD	H
	DAD	H
	DAD	D
	DAD	H
	SUI	48
	CPI	10
	CMC	
	RC
	MOV	E,A
	MVI	D,0
	DAD	D
	INX	B
	JMP	ADE1
BLK1	MVI	B,' '
	CALL	OUT8
	RET
ACHK	LHLD	BBUF
	LDA	BBUF+3
	CMP	H
	JNZ	ACH1
	LDA	BBUF+2
	CMP	L
	JNZ	ACH1
	STC
ACH1	INX	H
	SHLD	BBUF
	RET
NCOM	EQU	48
CTAB	DB	'APPE'
	DW	APPEND
	DB	'AUTO'
	DW	AUTOL
	DB	'BLOA'
	DW	BLOAD
	DB	'BSAV'
	DW	BSAVE
	DB	'CHAI'
	DW	CHAIN
	DB	'CHLL'
	DW	CHANGEALL
	DB	'CHNG'
	DW	CHANGE
	DB	'CONF'
	DW	CNFG2
	DB	'COPY'
	DW	COPYCMND
	DB	'DELE'
	DW	DELL
	DB	'DELT'
	DW	DELL
	DB	'DEVI'
	DW	UNITCMND
	DB	'DIR '
	DW	DIRECTORY
	DB	'DUMP'
	DW	DUMP1
	DB	'EDIT'
	DW	EDITCMND
	DB	'ERA '
	DW	ERASEFILE
	DB	'FIND'
	DW	FINDCMND
	DB	'FREE'
	DW	FREE
	DB	'HELP'
	DW	HELP
	DB	'JUST'
	DW	JUSTCMND
	DB	'LINE'
	DW	LINECMND
	DB	'LIST'
	DW	LIST
	DB	'LOAD'
	DW	LOADCMND
	DB	'MARG'
	DW	MARGINCMND
	DB	'MERG'
	DW	MERGECMND
	DB	'MOVE'
	DW	MOVECMND
	DB	'NULL'
	DW	NULLCMND
	DB	'OFFS'
	DW	OFFSCMND
	DB	'OPEN'
	DW	OPENCMND
	DB	'PAGE'
	DW	PAGECMND
	DB	'PNUM'
	DW	PNUMCMND
	DB	'PRIN'
	DW	PRINTCMND
	DB	'QUIT'
	DW	QUIT
	DB	'RECO'
	DW	RECOVER
	DB	'RENU'
	DW	RENUMBER
	DB	'REPE'
	DW	REPEATCMND
	DB	'SAVE'
	DW	SAVECMND
	DB	'SCRA'
	DW	SCRAT
	DB	'SPAC'
	DW	SPACECMND
	DB	'STAT'
	DW	STATCMND
	DB	'TABS'
	DW	TABSCMND
	DB	'TITL'
	DW	TITLECMND
	DB	'DEBU'
	DW	DEBUG
	DB	'UNIT'
	DW	OLDUNIT
	DB	'CALL'
	DW	NOTIMPL
	DB	'EXPA'
	DW	NOTIMPL
	DB	'NSAV'
	DW	SAVECMND
	DB	'DEST'
	DW	ERASEFILE
QUIT	CALL	CRLF
	LXI	D,QUITM
	CALL	SCRN
	CALL	CRLF
	MVI	C,0
	JMP	BDOS
BHEAD	DB	'  BLOCKS: '
	DB	'$'
CHEAD	DB	'  AVAILABLE: '
	DB	'$'
DHEAD	DB	' LAST LINE:'
	DB	'$'
OLDUNIT	LXI	D,UNITERR
	JMP	REPLY
UNITERR	DB	'FOR CP/M VERSION, USE: DEVICE L/C$'
VCHK	LDA	ABUF
	ORA	A
	JZ	ERR2
	RET
FREE	EQU	$
FREER	CALL	FREE1
	CALL	FREE2
	LXI	D,BHEAD
	CALL	SCRN
	LHLD	EOFP
	SHLD	MPTY
	MVI	E,2
	LXI	B,MPTY
	LXI	H,BOFP
	XRA	A
	CALL	ADSB1
	LHLD	MPTY
	INR	H
	MOV	L,H
	MVI	H,0
	SHLD	MPTY
	CALL	DECPT
	RET
FREE1	CALL	CRLF
	LXI	D,HEAD
	CALL	SCRN
	LHLD	EOFP
	SHLD	MPTY
	MVI	E,2
	LXI	B,MPTY
	LXI	H,BOFP
	XRA	A
	CALL	ADSB1
	CALL	DECPT
	LXI	D,CHEAD
	CALL	SCRN
	CALL	ADSUB
	CALL	DECPT
	RET
FREE2	LXI	D,DHEAD
	CALL	SCRN
	CALL	LABPT
	RET
ADSUB	LHLD	TOP
	SHLD	MPTY
	MVI	E,2
	LXI	B,MPTY
	LXI	H,EOFP
	XRA	A
ADSB1	LDAX	B
	SBB	M
	STAX	B
	DCR	E
	RZ
	INX	B
	INX	H
	JMP	ADSB1
LABPT	CALL	BLK1
	MVI	E,4
	LXI	H,MAXL
LABP2	MOV	B,M
	CALL	OUT8
	DCR	E
	RZ
	INX	H
	JMP	LABP2
SCRAT	CALL	CRLF
	CALL	CLEAN
	CALL	FREE1
	JMP	EOR
ERR1	CALL	CRLF
	LXI	D,MESS1X
	CALL	SCRN
	JMP	HELP
MESS1X	DB	'INVALID COMMAND'
	DB	'$'
ERR2	LXI	D,MESS2X
	JMP	REPLY
MESS2X	DB	'INVALID PARAMETER'
	DB	'$'
ERR3	CALL	CRLF
	LXI	D,MESS31
	CALL	SCRN
	CALL	CRLF
	LXI	D,IBUF
	CALL	SCRNCR
	JMP	DUMP
MESS31	DB	'INVALID CHARACTER IN PARAMETER --'
	DB	'$'
SMESS	DB	'CP/M SECRTARY REL '
	DB	'9.76'
	DB	'   $'
HEAD	DB	'USED: '
	DB	'$'
QUITM	DB	'FINISHED'
	DB	'$'
HELP	LXI	H,CTAB
	MVI	E,NCOM-6
HELP1	CALL	CRLF
	MVI	D,12
HELP2	MVI	C,4
HELP3	MOV	B,M
	CALL	OUT8
	INX	H
	DCR	C
	JNZ	HELP3
	INX	H
	INX	H
	MVI	B,' '
	CALL	OUT8
	CALL	CONTC
	JZ	EOR
	DCR	E
	JZ	EOR
	DCR	D
	JNZ	HELP2
	JMP	HELP1
LINER	CALL	LINE
	JMP	EOR
LINE	CALL	FILLN
	CALL	DELCK
	CALL	ADSUB
	LDA	MPTY+1
	ORA	A
	JNZ	OK2AD
	LDA	MPTY
	MOV	B,A
	LDA	IBUF-1
	SUB	B
	JC	OK2AD
	LXI	D,ERR4
	JMP	REPLY
ERR4	DB	'FILE FULL ERROR'
	DB	'$'
OK2AD	EQU	$
	MVI	C,4
	LXI	H,IBUF-1
LICK	INX	H
	MOV	A,M
	CPI	'0'
	JC	ERR3
	CPI	'9'+1
	JNC	ERR3
	DCR	C
	JNZ	LICK
	SHLD	HCON
	LXI	D,MAXL+3
	CALL	COM0
	JNC	INSR
	INX	H
	CALL	LODM
	LXI	H,MAXL+3
	CALL	STOM
	LXI	D,IBUF-1
	LHLD	EOFP
	MVI	C,1
	CALL	LMOV
SEOF	MVI	M,1
	SHLD	EOFP
	RET
INSR	CALL	FIN1
	MVI	C,2
	JZ	EQUL
	DCR	C
EQUL	MOV	B,M
	DCX	H
	MVI	M,2
	SHLD	INSP
	LDA	IBUF-1
	DCR	C
	JZ	LT1
	SUB	B
	JZ	ZERO
	JC	GT1
LT1	LHLD	EOFP
	MOV	D,H
	MOV	E,L
	CALL	ADR
	SHLD	EOFP
	MVI	C,2
	CALL	RMOV
	JMP	ZERO
GT1	CMA
	INR	A
	MOV	D,H
	MOV	E,L
	CALL	ADR
	XCHG
	CALL	LMOV
	MVI	M,1
	SHLD	EOFP
ZERO	LHLD	INSP
	MVI	M,13
	INX	H
	LXI	D,IBUF-1
	MVI	C,1
	CALL	LMOV
	RET
LFIND	EQU	$
FIND	LXI	H,ABUF+3
	SHLD	HCON
FIN1	LHLD	BOFP
	MOV	A,H
	ORA	L
	JZ	EOR
FI1	CALL	EO1
	XCHG
	LHLD	HCON
	XCHG
	MVI	A,4
	CALL	ADR
	CALL	COM0
	RC
	RZ
FI2	MOV	A,M
	CALL	ADR
	JMP	FI1
EOF	INX	H
EO1	MVI	A,1
	CMP	M
	RNZ
	MVI	A,CONSOLE
	STA	UNIT
	JMP	EOR
ADR	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET
LMOV	LDAX	D
	INX	D
	CMP	C
	RZ
	MOV	M,A
	INX	H
	JMP	LMOV
RMOV	LDAX	D
	DCX	D
	CMP	C
	RZ
	MOV	M,A
	DCX	H
	JMP	RMOV
LODM	MOV	B,M
	INX	H
	MOV	C,M
	INX	H
	MOV	D,M
	INX	H
	MOV	E,M
	RET
STOM	MOV	M,E
	DCX	H
	MOV	M,D
	DCX	H
	MOV	M,C
	DCX	H
	MOV	M,B
	RET
COM0	MVI	B,1
	MVI	C,4
	ORA	A
CO1	LDAX	D
	SBB	M
	JZ	CO2
	INR	B
CO2	DCX	D
	DCX	H
	DCR	C
	JNZ	CO1
	DCR	B
	RET
COM1	MVI	C,4
	LDAX	D
	SUI	1
	JMP	CO1+1
PARM	XRA	A
	STA	SAVE
	LXI	H,IBUF
	MOV	A,M
PARM1	CPI	'0'
	JC	ERR3
	CPI	'9'+1
	JNC	ERR3
	ANI	0FH
	MOV	E,A
	LDA	SAVE
	MOV	B,A
	RLC
	RLC
	RLC
	ADD	B
	ADD	B
	ADD	E
	STA	SAVE
	INX	H
	MOV	A,M
	CPI	13
	JZ	PEOF2
	JMP	PARM1
PEOF2	LDA	SAVE
	RET
NORM	CALL	LODM
	XRA	A
	CMP	B
	RZ
NOR1	CMP	E
	CNZ	STOM
	RNZ
	MOV	E,D
	MOV	D,C
	MOV	C,B
	MVI	B,'0'
	JMP	NOR1
DELCK	LXI	H,IBUF-1
	MOV	A,M
	CPI	6
	RNZ
	XRA	A
	STA	AUTO
	LXI	H,0
	SHLD	BBUF+2
	SHLD	FBUF
	CALL	ZBUF
	LXI	H,IBUF
	LXI	D,ABUF
	MVI	B,5
LOOP	DCR	B
	JZ	DEL6
	MOV	A,M
	STAX	D
	INX	D
	INX	H
	JMP	LOOP
DEL6	CALL	DEL0
	JMP	EOR
FILLN	LXI	H,IBUF
	MVI	C,4
FILL3	INX	H
	DCR	C
	RZ
FILL1	MOV	A,M
	CPI	'0'
	JC	FILL2
	CPI	'9'+1
	JNC	FILL2
	JMP	FILL3
FILL2	PUSH	D
	PUSH	H
	PUSH	B
	MVI	C,139
	LXI	D,IBUF+138
	LXI	H,IBUF+139
SHIFT	LDAX	D
	MOV	M,A
	DCX	D
	DCX	H
	DCR	C
	JNZ	SHIFT
	MVI	A,'0'
	STA	IBUF
	LDA	IBUF-1
	INR	A
	STA	IBUF-1
	POP	B
	POP	H
	POP	D
	JMP	FILL3
LISTCMND	EQU	$
LIST	CALL	CRLF
	CALL	RANGE
	CALL	FIND
LIST2	XRA	A
	STA	CNTR
LIST0	INX	H
	CALL	OUTPT
	CALL	EOF
	CALL	STOPL
	CALL	CONTC
	JZ	LIST3
	LDA	UNIT
	CPI	PRINTER
	JZ	LIST0
	LDA	SRCNT
	ORA	A
	JZ	LIST0
	MOV	B,A
	LDA	CNTR
	INR	A
	STA	CNTR
	CMP	B
	JC	LIST0
	PUSH	H
	LXI	D,MESS5
	CALL	SCRN
LIST1	CALL	IN8
	CPI	03
	JZ	LIST3
	CPI	13
	JNZ	LIST1
	CALL	CRLF
	POP	H
	JMP	LIST2
LIST3	MVI	A,CONSOLE
	STA	UNIT
	JMP	EOR
MESS5	DB	'PRESS RETURN TO CONTINUE'
	DB	'$'
STOPL	LXI	D,ABUF+4
	MVI	B,4
STOP1	LDAX	D
	ORA	A
	JNZ	STOP2
	INX	D
	DCR	B
	JNZ	STOP1
	RET
STOP2	PUSH	H
	INX	H
	LXI	D,ABUF+4
	MVI	B,4
STOP4	LDAX	D
	CMP	M
	JZ	STOP3
	JC	EOR
	POP	H
	RET
STOP3	INX	H
	INX	D
	DCR	B
	JNZ	STOP4
	POP	H
	RET
DELL	CALL	VCHK
	CALL	RANGE
DEL0	CALL	FIND
	SHLD	INSP
	LXI	H,ABUF+7
	MOV	A,M
	ORA	A
	JNZ	DEL1
	LXI	H,ABUF+3
DEL1	SHLD	HCON
	XCHG
	LXI	H,MAXL+3
	CALL	COM0
	LHLD	INSP
	JC	NOVR
	SHLD	EOFP
	MVI	M,1
	XCHG
	LHLD	BOFP
	XCHG
	MVI	B,13
	DCX	H
DEL2	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	MVI	A,13
	JC	DEL4
	DCR	B
	DCX	H
	CMP	M
	JNZ	DEL2
	DCX	H
	MOV	A,L
	SUB	E
	MOV	A,H
	SBB	D
	JC	DEL5
	CMP	M
	INX	H
	INX	H
	JZ	DEL3
	INX	H
DEL3	CALL	LODM
	LXI	H,MAXL+3
	CALL	STOM
	RET
DEL4	CMP	B
DEL5	XCHG
	JNZ	DEL3-1
	STA	MAXL
	RET
NOVR	CALL	FI1
	CZ	FI2
NOV1	XCHG
	LHLD	INSP
	MVI	C,1
	CALL	LMOV
	SHLD	EOFP
	MVI	M,1
	RET
SBLK	LHLD	PNTR
SBL1	MOV	A,M
	CPI	','
	JZ	SBL2
	CPI	' '
	RNZ
SBL2	INX	H
	SHLD	PNTR
	JMP	SBL1
ALPS	MVI	B,0
ALP1	STAX	D
	INR	B
	MOV	A,B
	CPI	11
	RNC
	INX	D
	INX	H
	SHLD	PNTR
	MOV	A,M
	CPI	'0'
	RC
	CPI	'9'+1
	JC	ALP1
	CPI	'A'
	RC
	CPI	'Z'+1
	JC	ALP1
	RET
DECPT	XRA	A
	STA	LAST
	LXI	H,2710H
	SHLD	TEMP2
	CALL	DIVID
	LXI	H,03E8H
	SHLD	TEMP2
	CALL	DIVID
	LXI	H,64H
	SHLD	TEMP2
	CALL	DIVID
	LXI	H,0AH
	SHLD	TEMP2
	CALL	DIVID
	LDA	MPTY
	ADI	'0'
	MOV	B,A
	CALL	OUT8
	RET
DIVID	MVI	E,0
	LHLD	MPTY
	SHLD	TEMP
SB2	LXI	B,TEMP
	LXI	H,TEMP2
	XRA	A
	LDAX	B
	SBB	M
	STAX	B
	INX	B
	INX	H
	LDAX	B
	SBB	M
	STAX	B
	JC	NEG
	INR	E
	PUSH	H
	LHLD	TEMP
	SHLD	MPTY
	POP	H
	JMP	SB2
NEG	MOV	A,E
DIV2	ADI	'0'
	MOV	B,A
	LDA	LAST
	ORA	A
	JNZ	DIV4
	MOV	A,B
	CPI	'0'
	RZ
	STA	LAST
DIV4	CALL	OUT8
	RET
LNGEN	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,2
	LXI	H,NUMBR
	LXI	D,LINE1
CONVT1	LDAX	D
	RRC
	RRC
	RRC
	RRC
	CALL	UNPAK
	LDAX	D
	CALL	UNPAK
	INX	D
	DCR	C
	JNZ	CONVT1
	POP	H
	MVI	C,4
	LXI	D,NUMBR
LOOP21	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	C
	JNZ	LOOP21
	PUSH	H
	MVI	C,2
	LXI	D,LINE1+1
	LXI	H,INCR+1
	XRA	A
LOOP11	LDAX	D
	ADC	M
	DAA
	STAX	D
	DCR	C
	DCX	D
	DCX	H
	JNZ	LOOP11
	POP	H
	POP	D
	POP	B
	RET
AUTOL	LXI	H,0500H
	SHLD	INCR
	CALL	VCHK
	LXI	H,LINE1
	LXI	D,ABUF
	CALL	PACK
	LXI	H,INCR
	LDAX	D
	CPI	0
	JZ	SWITH
	CALL	PACK
SWITH	MVI	A,1
	STA	AUTO
	JMP	EOR
PACK	CALL	TWICE
TWICE	CALL	TEST
	RLC
	RLC
	RLC
	RLC
	MOV	B,A
	INX	D
	CALL	TEST
	ADD	B
	MOV	M,A
	INX	D
	INX	H
	RET
TEST	LDAX	D
	CPI	'0'
	JC	ERR3
	CPI	'9'+1
	JNC	ERR3
	ANI	0FH
	RET
UNPAK	ANI	0FH
	ADI	'0'
	MOV	M,A
	MOV	B,A
	LDA	AUTO
	ORA	A		;IF AUTO NOT ON
	JZ	SKIPOUT8	;SKIP DISPLAYING THE NUMBER
	CALL	OUT8
SKIPOUT8 INX	H
	RET
EDITCMND	CALL	CRLF
	MVI	B,'>'
	CALL	OUT8
	MVI	A,1
	STA	HALT
	LDA	ABUF
	ORA	A
	JZ	ERR9
	XRA	A
	STA	TEMP
	CALL	FIND
	INX	H
	LXI	D,TBUF
CPY2	MOV	A,M
	STAX	D
	MOV	B,A
	CALL	OUT8
	MOV	A,B
	CPI	13
	JZ	DPLAY
	INX	H
	INX	D
	JMP	CPY2
DPLAY	CALL	CRLF
	MVI	B,'>'
	CALL	OUT8
	JMP	RESTR
ERR9	LXI	D,ERRM9
	JMP	REPLY
ERRM9	DB	'MISSING LINE NO.'
	DB	'$'
UPPERCASE	CPI	60H	;CONVERT LOWER TO UPPERCASE
	RC
	SBI	20H
	RET
GETFCB	CALL	SETUP	;CREATE AN FCB
	MVI	C,36
	XRA	A
	LXI	D,FCB
CLEARFCB	STAX	D	;RESET FCB TO ZEROES
	INX	D
	DCR	C
	JNZ	CLEARFCB
	PUSH	H	;SAVE POSITION OF DRIVE NO
	INX	H	;CHECK FOR COLON
	MOV	A,M
	CPI	':'
	JNZ	NOCOLON
	POP	H
	MOV	A,M
	ANI	0FH	;CONVERT A=1...P=16
	STA	FCB
	INX	H	;POINT TO COLON
	INX	H	;POINT TO 1ST CHAR OF NAME
	JMP	GETNAME
NOCOLON	POP	H
GETNAME	LXI	D,FCB+1
	MVI	C,11
	MVI	A,20H
CLEARNAME	STAX	D
	INX	D
	DCR	C
	JNZ	CLEARNAME
	MVI	A,'T'		;DEFAULT TO LOAD TXT FILE TYPE
	STA	FCB+9
	STA	FCB+11
	MVI	A,'X'
	STA	FCB+10
	LXI	D,FCB+1
	MVI	C,8
MOVENAME	MOV	A,M
	CPI	'.'
	JZ	PERIOD
	CPI	13
	RZ
	CALL	UPPERCASE
	STAX	D
	INX	D
	INX	H
	DCR	C
	JNZ	MOVENAME
	MOV	A,M
	CPI	13
	RZ
	CPI	'.'
	JNZ	ERR2
PERIOD	LXI	D,FTYPE
	INX	H
	MVI	C,3
MOVETYPE	MOV	A,M
	CPI	13
	RZ
	CALL	UPPERCASE
	STAX	D
	INX	D
	INX	H
	DCR	C
	JNZ	MOVETYPE
	MOV	A,M
	CPI	13
	JNZ	ERR2
	RET
; TRANSFER DATA TO/FROM MEMORY/DISK
MEMTRANS	LHLD 	BOUND
NEXTREC	PUSH	H
	LXI	D,128
	DAD	D
	LDA	TOP+1
	CMP	H
	JZ	COMPAREL
	JC	TOOLARGE
	JMP	SPACEOK
COMPAREL	LDA	TOP
	CMP	L
	JZ	TOOLARGE
	JC	TOOLARGE
SPACEOK	POP	H
	MVI	C,26	;SET DMA ADDRESS
	XCHG		;HL TO DE
	CALL	BDOS
	LXI	D,FCB
	LDA	RWIND	;SET TO READ OR WRITE
	MOV	C,A
	CALL	BDOS
	INR	A
	JZ	MEMERR
	LHLD	BOUND
	MVI	C,128
FINDEOF	MOV	A,M	;SEE IF EOF WAS TRANSFERED
	CPI	01
	JZ	DMARESET	;RESET DMA BEFORE QUITTING
	INX	H
	DCR	C
	JNZ	FINDEOF
	SHLD	BOUND
	JMP	NEXTREC
TOOLARGE	EQU	$
	CALL	DMARESET
	LXI	D,OVERSIZE
	JMP	REPLY
MEMERR	CALL	DMARESET
	LXI	D,IOERR
	JMP	REPLY
DMARESET	MVI	C,0DH	;RESET THE DISK SYSTEM
	JMP	BDOS
OVERSIZE	DB	'FILE TOO LARGE TO LOAD$'
IOERR	DB	'DISK I/O ERROR$'
LOADCMND	CALL	CRLF
	LHLD	BOFP
LOAD7	SHLD	BOUND
	CALL	LOADR
	CALL	FREE
	JMP	EOR
APPEND	CALL	CRLF
	LHLD	EOFP
	JMP	LOAD7
CHAIN	LHLD	BOFP
	SHLD	BOUND
	CALL	LOADR
	LXI	H,0000
	SHLD	ABUF
	SHLD	ABUF+2
	JMP	PRINTCMND
ERASEFILE	CALL	CRLF	;DELETE A FILE
	CALL	GETFCB
	LXI	D,FCB
	MVI	C,0FH	;OPEN THE FILE TO SEE IF IT IS THERE
	CALL	BDOS
	LXI	D,NOFILE
	INR	A
	JZ	REPLY
	LXI	D,CONFIRM	;SEND CONFIRMATION QUESTION
	CALL	SCRN
	CALL	CIN
	MOV	B,A
	CALL	COUT
	MOV	A,B
	CALL	UPPERCASE
	CPI	'N'
	JZ	EOR
	CPI	'Y'
	JNZ	ERR2
	LXI	D,FCB
	MVI	C,13H	;DELETE THE FILE NOW
	CALL	BDOS
	JMP	EOR
CONFIRM	DB	'ARE YOU SURE (Y/N)? $'
NOFILE	DB	'FILE CANNOT BE FOUND$'
LOADR	CALL	GETFCB
	LXI	D,FCB
	MVI	C,0FH	;OPEN THE FILE
	CALL	BDOS
	LXI	D,NOFILE
	INR	A
	JZ	REPLY
	MVI	A,14H	;SET SEQUENTIAL READ
	STA	RWIND
	CALL	MEMTRANS	;DO ACTUAL LOAD
FINDEND	LHLD	BOFP		;SEARCH FOR THE END OF DATA
LOAD2	LXI	D,MAXL
	MVI	C,4
LOAD1	INX	H
	MOV	A,M
	STAX	D
	INX	D
	DCR	C
	JNZ	LOAD1
LOAD3	INX	H
	MVI	A,0DH
	CMP	M
	JNZ	LOAD3
	INX	H
	MVI	A,1
	CMP	M
	JNZ	LOAD2
LOAD4	SHLD	EOFP
	RET
SAVECMND	CALL	CRLF
	CALL	GETFCB
	MVI	C,0FH	;ATTEMP TO OPEN
	LXI	D,FCB
	CALL	BDOS
	INR	A
	JZ	CREATEFILE
	LHLD	FTYPE	;CREATE BACKUP NAME
	SHLD 	HTYPE
	LHLD	FTYPE+2
	SHLD	HTYPE+2
	MVI	A,'B'
	STA	FTYPE
	MVI	A,'A'
	STA	FTYPE+1
	MVI	A,'K'
	STA	FTYPE+2
	LXI	D,FCB
	MVI	C,0FH	;SEE IF BAK EXISTS
	CALL	BDOS
	INR	A
	JZ	RENAMEIT
	LXI	D,FCB
	MVI	C,13H	;DELETE BACKUP FILE
	CALL	BDOS
RENAMEIT	LXI	D,FCB+16	;COPY THE NAME
	LXI	H,FCB
	MVI	C,16
COPYNAME	MOV	A,M
	STAX	D
	INX	D
	INX	H
	DCR	C
	JNZ	COPYNAME
	LHLD	HTYPE
	SHLD	FTYPE
	LDA	HTYPE+2
	STA	FTYPE+2
	LXI	D,FCB
	MVI	C,17H	;RENAME TO BACKUP
	CALL	BDOS
	LXI	D,NORENAME
	INR	A
	JZ	REPLY
	CALL 	NEWSECTOR
	LXI	D,FCB+16
	MVI	C,17
	XRA	A	;CLEAR THE RENAMEED FCB
WIPEOUT	STAX	D
	INX	D
	DCR	C
	JNZ	WIPEOUT
CREATEFILE	LXI	D,FCB	;MAKE A NEW FILE
	MVI	C,16H
	CALL	BDOS
	LXI	D,DISKFULL
	INR	A
	JZ	REPLY
	LHLD	BOFP
	SHLD	BOUND
	MVI	A,15H	;SET SEQUENTIAL WRITE
	STA	RWIND
	CALL	MEMTRANS	;WRITE THE FILE
CLOSEIT	MVI	C,10H		;CLOSE THE FILE
	LXI	D,FCB
	CALL	BDOS
	LXI	D,BADCLOSE
	INR	A
	JZ	REPLY
	CALL	NEWSECTOR
	LXI	D,SAVED
	JMP	REPLY
; IF YOU DO TWO SAVES IN A ROW, CPM WILL OVERWRITE THE FIRST ONE WITH
; THE DATA FROM THE SECOND ONE.  TO PREVENT ANY DISK IO PROBLEMS, 
; RESET THE DISK SYSTEM AFTER A SAVE.
NEWSECTOR EQU	$
	MVI	C,0DH
	CALL	BDOS
	RET
SAVED	DB	'SAVED$'
BADCLOSE	DB	'BAD CLOSE -- NOT SAVED$'
DISKFULL	DB	'DISK FULL -- NOT SAVED$'
NORENAME	DB	'CANNOT RENAME BACKUP$'
NULLO	LDA	NULLC
	ORA	A
	RZ
	PUSH	D
	MOV	E,A
NULL2	MVI	B,0
	CALL	OUT8A
	DCR	E
	JNZ	NULL2
NULL3	POP	D
	RET
MERGECMND	EQU	$	;MERGE COMMAND FOR MERGING BASIC DATA
	CALL	CRLF		;INTO FORM LETTERS
	CALL	GETFCB
	LXI	D,FCB		;COPY THE FCB TO A MERGE-FCB (MFCB)
	LXI	H,MFCB		;SO ANY OTHER DISK COMMANDS WILL NOT
	MVI	B,36		;DESTROY THE FCB SET UP FOR THIS COMMAND
SAVEFCB	LDAX	D
	MOV	M,A		;COPY FCB
	INX	H
	INX	D
	DCR	B
	JNZ	SAVEFCB
	LXI	D,MFCB
	MVI	C,0FH		;OPEN THE FILE
	CALL	BDOS
	LXI	D,NOFILE	;SEE IF FILE IS THERE
	INR	A
	JZ	REPLY
	CALL	GETBA		;GET THE FIRST RECORD
	LHLD	BUFAD
	MOV	A,M
	INX	H		;GET THE FIRST CHARACTER
	SHLD	BUFAD
	CPI	22H		;MUST BE A DOUBLE QUOTE
	JZ	INRRCX
	LXI	D,MRGERR
	JMP	REPLY
MRGERR	DB	'RECORD DOES NOT BEGIN WITH DOUBLE QUOTE$'
INRRCX	LDA	BUFCT
	DCR	A
	STA	BUFCT
	JMP	EOR
GETBA	PUSH	H
	PUSH	B
	PUSH	D
	CALL	RSTBA
	LXI	D,MBUF		;SET DMA FOR MERGE BUFFER
	MVI	C,1AH
	CALL	BDOS
	LXI	D,MFCB		;READ SEQUENTIAL
	MVI	C,14H
	CALL	BDOS
	ORA	A		;CHECK FOR EOF
	CNZ	EOFBA
	POP	D
	POP	B
	POP	H
	RET
EOFBA	LDA	INSRT
	ORA	A
	RZ
	XRA	A
	STA	RPEAT
	STA	INSRT
	MVI	A,1
	STA	INHIB
	RET
RSTBA	MVI	A,99
	STA	RPEAT
	XRA	A
	STA	INHIB
	MVI	A,1
	STA	INSRT
	LXI	H,MBUF
	SHLD	BUFAD
	MVI	A,128
	STA	BUFCT
	RET
MOVBA	LDA	INHIB
	ORA	A
	RNZ
	PUSH	H
	PUSH	B
MOV0	LHLD	BUFAD
	MOV	A,M
	CPI	'+'
	JZ	MOV1
	STAX	D
	INX	D
	LDA	NCHR
	INR	A
	STA	NCHR
	MOV	B,A
	LDA	CCNT
	CMP	B
	JZ	LFULL
	CALL	INRBF
	LDA	INHIB
	ORA	A
	JZ	MOV0
	JMP	POPIT
MOV1	CALL	INRBF
POPIT	POP	B
	POP	H
	RET
LFULL	CALL	INRBF
	LHLD	BUFAD
	MOV	A,M
	CPI	'+'
	JZ	MOV1
	LDA	INHIB
	ORA	A
	JZ	LFULL
	JMP	POPIT
INRBF	INX	H
	SHLD	BUFAD
	LDA	BUFCT
	DCR	A
	STA	BUFCT
	CZ	GETBA
	LHLD	BUFAD			;REFILL BUFFER
	MOV	A,M
	CPI	22H			;DOUBLE QUOTE?
	RNZ
	MVI	A,1
	STA	INHIB
	RET
FLUSH	PUSH	H
	PUSH	B
FLSH1	LHLD	BUFAD
	MOV	A,M
	CPI	22H		;FIND QUOTE AT END OF CURRENT RECORD
	JZ	FLSH2
	CPI	1AH		;END OF FILE?
	JZ	FLSH3
	CALL	INRBF
	JMP	FLSH1
FLSH2	CALL	INRBF
	LHLD	BUFAD
	MOV	A,M
	CPI	1AH		;END OF FILE?
	JZ	FLSH3
	CPI	22H		;FIND QUOTE AT BEGINNING OF NEXT RECORD
	JNZ	FLSH2
	CALL	INRBF
	XRA	A
	STA	INHIB
	POP	B
	POP	H
	RET
FLSH3	POP	B
	POP	H
	JMP	EOFBA
NOTIMPL	LXI	D,NOTIMSG
	JMP	REPLY
NOTIMSG	DB	'COMMAND NOT IMPLEMENTED$'
;OUTPUT	A	CARRIAGE RETURN LINE FEED
CRLF	MVI	B,13
	CALL	OUT8
	MVI	B,10
	CALL	OUT8
	CALL	NULLO
	RET
;ECHOE	TAB	CHAR AS @
;OUTPUT	A	CHARACTER TO THE CONSOLE
OUT8	MVI	A,09
	CMP	B
	JNZ	SKIP1X
	MVI	B,'@'
SKIP1X	XRA	A
COUTZ	PUSH	H
	PUSH	D
	PUSH	B
	MVI	C,CONSOLE
	MOV	E,B
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	RET
;OUTPUT	A	CHARACTER TO UNIT "UNIT"
OUT8A	MVI	A,09
	CMP	B
	JNZ	COUT
	MVI	B,'@'
	JMP	COUT
IN8	EQU	$
CIN	PUSH	H
	PUSH	D
	PUSH	B
CIN1	MVI	C,06
	MVI	E,0FFH
	CALL	BDOS
	ORA	A
	JZ	CIN1
	POP	B
	POP	D
	POP	H
	RET
COUT	PUSH	H
	PUSH	D
	PUSH	B
	LDA	UNIT
	MOV	C,A
COUT2	MOV	E,B
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	RET
CONTC	PUSH	H
	PUSH	D
	PUSH	B
	MVI	C,6
	MVI	E,0FFH
	CALL	BDOS
	ORA	A
	JZ	NCONTC
	CPI	03
	JNZ	NCONTC
	MVI	A,'Y'
	JMP	CONTC2
NCONTC	MVI	A,'N'
CONTC2	CPI	'Y'
	POP	B
	POP	D
	POP	H
	RET
SCRN	MVI	C,9
	JMP	BDOS
SCRNCR	LDAX	D
	CPI	13
	RZ
	MOV	B,A
	CALL	OUT8
	INX	D
	JMP	SCRNCR
;LINE	PRINT	FOR LIST AND PRINT COMMANDS
OUTPT	MOV	B,M
	MVI	A,13
	CMP	B
	JZ	OUTDN
	CALL	OUT8A
	INX	H
	JMP	OUTPT
OUTDN	CALL	OUTCR
	LDA	SPACE
	ORA	A
	RZ
	PUSH	B
	MOV	C,A
OUTA	DCR	C
	JZ	OUTB
	CALL	OUTCR
	JMP	OUTA
OUTB	POP	B
	RET
OUTCR	MVI	B,13
	CALL	OUT8A
	MVI	B,10
	CALL	OUT8A
	CALL	NULLO
	RET
;DISPLAY	AN	ERROR MESSAGE
REPLY	CALL	CRLF
	CALL	SCRN
	JMP	EOR
;	RESET	INPUT BUFFER
SETUP	LXI	H,IBUF
SET1	INX	H
	MOV	A,M
	CPI	13
	RZ
	CPI	' '
	JNZ	SET1
SET2	INX	H
	MOV	A,M
	CPI	13
	RZ
	CPI	' '
	JZ	SET2
	RET
DEBUG	MVI	A,1
	STA	DBFLG
	JMP	EOR
DUMP1	CALL	OUTCR
	LHLD	BBUF+2
	XCHG
	LHLD	BBUF
	LDA	IBUF-1
	CPI	6
	JZ	DPRAM
	CALL	DUMP3
	CALL	OUTCR
	JMP	EOR
DPRAM	CALL	DUMP4
	CALL	OUTCR
	JMP	EOR
DUMP	EQU	$
DUMP2	LDA	DBFLG
	ORA	A
	JZ	EOR
DUMP4	LXI	D,TBUF+140
	LXI	H,AREA
	CALL	DUMP3
	JMP	EOR
DUMP5	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
	SHLD	HL
	XCHG
	SHLD	DE
	JMP	H0
DUMP3	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
	SHLD	HL
	XCHG
	SHLD	DE
REASK	CALL	CRLF
	LXI	D,DEVICEMSG
	CALL	SCRN
	CALL	CIN
	CPI	03
	JZ	EOR
	MOV	B,A
	CALL	OUT8
	MOV	A,B
	CPI	'L'
	JZ	LISTDEVICE
	CPI	6CH	;LOWER CASE L
	JZ	LISTDEVICE
	CPI	63H	;LOWER CASE C
	JZ	CONDEVICE
	CPI	'C'
	JNZ	REASK
CONDEVICE	EQU	$
	MVI	A,CONSOLE
	JMP	SETDEVICE
LISTDEVICE	MVI	A,PRINTER
SETDEVICE	STA	UNIT
	CALL	CRLF
H0	LXI	H,HL+1
	CALL	HEX
	LXI	H,HL
	CALL	HEX
	LHLD	HL
	MVI	D,8
H2	MVI	B,' '
	CALL	OUT8A
	MVI	E,4
H1	CALL	HEX
	INX	H
	DCR	E
	JNZ	H1
	DCR	D
	JNZ	H2
	LHLD	HL
	MVI	B,' '
	CALL	OUT8A
	MVI	D,32
H4	MOV	A,M
	CPI	20H
	JC	H5
	CPI	7EH
	JC	H3
H5	MVI	A,'.'
H3	MOV	B,A
	CALL	OUT8A
	INX	H
	DCR	D
	JNZ	H4
	CALL	OUTCR
	SHLD	HL
	CALL	CONTC
	JZ	EOR
	LDA	HL+1
	MOV	B,A
	LDA	DE+1
	CMP	B
	JZ	H6
	JNC	H0
	JMP	H7
H6	LDA	HL
	MOV	B,A
	LDA	DE
	CMP	B
	JZ	H7
	JNC	H0
H7	MVI	A,CONSOLE
	STA	UNIT
	POP	PSW
	POP	B
	POP	D
	POP	H
	RET
DEVICEMSG	DB	'DEVICE (L/C)? $'
HEX	PUSH	H
	MOV	A,M
	CALL	BINH
	LXI	H,HCON
	MOV	B,M
	CALL	OUT8A
	INX	H
	MOV	B,M
	CALL	OUT8A
	POP	H
	RET
BINH	LXI	H,HCON
	MOV	B,A
	RAR
	RAR
	RAR
	RAR
	CALL	BIN1
	MOV	M,A
	INX	H
	MOV	A,B
	CALL	BIN1
	MOV	M,A
	RET
BIN1	ANI	0FH
	ADI	48
	CPI	58
	RC
	ADI	7
	RET
MOVECMND	MVI	A,1
	JMP	COPYCMND+1
COPYCMND	EQU	$
	XRA	A
	STA	TEMP3
	CALL	RANGE
GETLN	EQU	$
	LXI	H,0100H
	SHLD	INCR
	LXI	H,LINE1
	LXI	D,ABUF+8
	CALL	PACK
	XRA	A
	STA	TEMP3+1
	LXI	D,ABUF+8
	LXI	H,ABUF
	MVI	B,4
AGAIN	LDAX	D
	CMP	M
	JC	BKWRD
	JNZ	FRWRD
	INX	H
	INX	D
	DCR	B
	JZ	FRWRD
	JMP	AGAIN
BKWRD	MVI	A,1
	STA	TEMP3+1
FRWRD	CALL	LFIND
MOVL	SHLD	ADDR1
	LXI	D,IBUF-1
	MOV	A,M
	STAX	D
	INX	D
	INX	H
MOVX	MOV	A,M
	STAX	D
	CPI	13
	JZ	COPD
	INX	H
	INX	D
	JMP	MOVX
COPD	SHLD	ADDR2
	INX	D
	MVI	A,1
	STAX	D
	LXI	H,IBUF
	CALL	LNGEN
	CALL	LINE
	LXI	D,ABUF+4
	LHLD	ADDR1
	LDA	TEMP3+1
	ORA	A
	JZ	SKPAD
	LHLD	ADDR2
	INX	H
	SHLD	ADDR1
	INX	H
	CALL	ADVNC
	SHLD	ADDR2
	LHLD	ADDR1
SKPAD	INX	H
	MVI	B,5
ENDD	DCR	B
	JZ	DONE
	LDAX	D
	CMP	M
	JNZ	CNEXT
	INX	D
	INX	H
	JMP	ENDD
CNEXT	LHLD	ADDR2
	INX	H
	MOV	A,M
	CPI	1
	JZ	DONE
	PUSH	B
	PUSH	H
	PUSH	D
	MVI	B,4
	INX	H
	LXI	D,ABUF+4
RETRY	LDAX	D
	CMP	M
	JC	DONE
	JNZ	RESET
	INX	H
	INX	D
	DCR	B
	JZ	RESET
	JMP	RETRY
ADVNC	INX	H
AD	MOV	A,M
	CPI	13
	JZ	FNDIT
	INX	H
	JMP	AD
FNDIT	RET
RESET	POP	D
	POP	H
	POP	B
	JMP	MOVL
DONE	LDA	TEMP3
	ORA	A
	JNZ	MOVC
	LXI	D,MESS1
	JMP	REPLY
MESS1	DB	'COPIED'
	DB	'$'
MOVC	CALL	DELL
	LXI	D,MESS2
	JMP	REPLY
MESS2	DB	'MOVED'
	DB	'$'
CHANGE	MVI	A,1
	JMP	CHANGEALL+1
CHANGEALL	XRA	A
	STA	TEMP3
FINDZ	CALL	CRLF
	LXI	H,IBUF
	LXI	D,TBUF
EDIT5	MOV	A,M
	STAX	D
	CPI	13
	JZ	EDIT6
	INX	H
	INX	D
	JMP	EDIT5
EDIT6	LXI	H,TBUF
	CALL	SET1
	XRA	A
	STA	CNTR
CHNG1	MVI	A,13
	CMP	M
	JZ	ERR2
	MVI	A,' '
	CMP	M
	JNZ	CHNG5
	INX	H
	JMP	CHNG1
CHNG5	SHLD	ADDR1
CHNG6	MVI	A,13
	CMP	M
	JZ	ERR2
	MVI	A,'^'
	CMP	M
	JZ	CHNG2
	INX	H
	JMP	CHNG6
CHNG2	LHLD	BOFP
	INX	H
CHNGX	SHLD	ADDR2
	INX	H
	INX	H
	INX	H
	INX	H
	SHLD	ADDR3
	XCHG
	LHLD	ADDR1
	XCHG
CHNG3	LDAX	D
	CPI	'^'
	JZ	FUND
	CMP	M
	JNZ	NOTXX
	INX	H
	INX	D
	JMP	CHNG3
NOTXX	LHLD	ADDR1
	XCHG
	LHLD	ADDR3
	INX	H
	SHLD	ADDR3
	MVI	A,13
	CMP	M
	JNZ	CHNG3
	SHLD	ADDR3
EOFXX	LHLD	ADDR3
	INX	H
	MVI	A,1
	CMP	M
	JZ	FINIX
	CALL	CONTC
	JZ	EOR
	INX	H
	JMP	CHNGX
FUND	LDA	CNTR
	INR	A
	STA	CNTR
	CALL	REDIT
	LDA	TEMP3
	ORA	A
	JZ	CHNG4
	LXI	D,IBUF
	CALL	SCRNCR
IN1	CALL	IN8
	CPI	13
	JZ	KEEP
	CPI	03
	JZ	EOR
	CPI	01
	JZ	DELT
	CPI	20H
	JZ	DELT
	JMP	IN1
KEEP	CALL	CRLF
CHNG4	CALL	LINE
	JMP	EOFXX
DELT	CALL	CRLF
	LHLD	ADDR4
	SHLD	ADDR3
	JMP	EOFXX
FINIX	LDA	CNTR
	ORA	A
	JNZ	EOR
	LXI	D,MESS3X
	JMP	REPLY
MESS3X	DB	'CHAR NOT FOUND'
	DB	'$'
REDIT	LXI	B,IBUF
	MVI	A,6
	STA	INCR
	LHLD	ADDR2
	MVI	D,5
EDIT3	DCR	D
	JZ	EDIT4
	MOV	A,M
	STAX	B
	INX	H
	INX	B
	JMP	EDIT3
EDIT4	SHLD	ADDR3
	XCHG
	LHLD	ADDR1
	XCHG
EDIT1	LDAX	D
	CPI	'^'
	JZ	STFND
	CMP	M
	JNZ	STNF
	INX	H
	INX	D
	JMP	EDIT1
STNF	LHLD	ADDR3
	MOV	A,M
	STAX	B
	INX	B
	LDA	INCR
	INR	A
	STA	INCR
	CPI	139
	JZ	ERR4X
	LHLD	ADDR1
	XCHG
	LHLD	ADDR3
	INX	H
	SHLD	ADDR3
	MVI	A,13
	CMP	M
	JNZ	EDIT1
ERR4X	LXI	D,MESS4X
	JMP	REPLY
MESS4X	DB	'CHAR OVERFLOW'
	DB	'$'
	JMP	LNFUL
STFND	INX	D
EDIT2	LDAX	D
	CPI	13
	JZ	DADD
	STAX	B
	INX	B
	INX	D
	LDA	INCR
	INR	A
	STA	INCR
	CPI	139
	JZ	LNFUL
	JMP	EDIT2
DADD	MOV	A,M
	CPI	13
	JZ	LNFUL
	STAX	B
	INX	H
	INX	B
	LDA	INCR
	INR	A
	STA	INCR
	CPI	139
	JZ	LNFUL
	JMP	DADD
LNFUL	MVI	A,13
	STAX	B
	INX	B
	MVI	A,1
	STAX	B
	SHLD	ADDR4
	STAX	B
	LHLD	ADDR2
	DCX	H
	DCX	H
	SHLD	ADDR3
	LDA	INCR
	STA	IBUF-1
	RET
RECOVER	CALL	RVSUB
	ORA	A
	JNZ	RCVR9
	CALL	FREE
	LXI	D,MESSA6
	JMP	REPLY
RCVR9	LXI	D,MESSA5
	JMP	REPLY
MESSA5	DB	'CANNOT RECOVER'
	DB	'$'
MESSA6	DB	'RECOVERY SUCCESSFUL'
	DB	'$'
RVSUB	LHLD	BOFP
	MOV	A,M
	CPI	01
	JNZ	RCVR5
	MVI	B,2
RCVR1	INX	H
	MOV	A,M
	CPI	13
	JZ	RCVR2
	INR	B
	MVI	A,139
	CMP	B
	JNZ	RCVR1
	MVI	A,1
	RET
RCVR2	LHLD	BOFP
	MOV	M,B
	JMP	RECOVER
RCVR5	SHLD	ADDR1
RCVR3	XCHG
	LHLD	ADDR1
	SHLD	ADDR2
	XCHG
	SHLD	ADDR1
	MOV	A,M
	CPI	01
	JZ	RCVRD
	MOV	B,A
	DCR	B
RCVR4	INX	H
	LDA	TOP+1
	CMP	H
	JNZ	RCVR7
	LDA	TOP
	CMP	L
	JZ	RCVR8
RCVR7	DCR	B
	JNZ	RCVR4
	MOV	A,M
	INX	H
	CPI	13
	JZ	RCVR3
RCVR8	LHLD	ADDR1
	MVI	A,01
	MOV	M,A
RCVRD	SHLD	EOFP
	LHLD	ADDR2
	INX	H
	MVI	B,4
	LXI	D,MAXL
RCVR6	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	B
	JNZ	RCVR6
	XRA	A
	RET
JUSTCMND	CALL	SETUP
JUST3	MOV	A,M
	CPI	13
	JZ	JUST5
	CPI	'O'
	JZ	JUST4
	CPI	6FH
	JZ	JUST4
	INX	H
	JMP	JUST3
JUST4	INX	H
	MOV	A,M
	CPI	'N'
	JZ	XJON
	CPI	6EH
	JZ	XJON
	CPI	'F'
	JZ	XJOFF2
	CPI	66H
	JZ	XJOFF2
JUST5	LDA	JSW
JUST6	ORA	A
	JZ	XJOFF
	LXI	D,MES12
	JMP	REPLY
XJOFF	LXI	D,MES11
	JMP	REPLY
XJON	MVI	A,1
	JMP	XJOFF2+1
XJOFF2	XRA	A
	STA	JSW
	JMP	JUST6
MES11	DB	'JUSTIFY OFF'
	DB	'$'
MES12	DB	'JUSTIFY ON'
	DB	'$'
NULLCMND	CALL	SETUP
	CALL	GPARM
	STA	NULLC
	LXI	D,MESSD
	JMP	REPLY
MESSD	DB	'NULL COUNT ACCEPTED'
	DB	'$'
OFFSCMND	CALL	SETUP
	CALL	GPARM
	STA	OFFST
	LXI	D,MESSO
	JMP	REPLY
MESSO	DB	'OFFSET ACCEPTED'
	DB	'$'
MARGINCMND	CALL	SETUP
	CALL	GPARM
	ORA	A
	JZ	ERR2
	DCR	A
	STA	OFFST
	CALL	GPARM
	ORA	A
	JZ	ERR2
	CPI	132
	JNC	ERR2
	MOV	B,A
	LDA	OFFST
	MOV	C,A
	MOV	A,B
	SUB	C
	JC	ERR2
	STA	LINES
	LXI	D,MESSM
	JMP	REPLY
MESSM	DB	'MARGINS SET'
	DB	'$'
PNUMCMND	CALL	SETUP
	CALL	GPARM
	DCR	A
	STA	PNO
	LXI	D,MESSP
	JMP	REPLY
MESSP	DB	'PAGE NO ACCEPTED'
	DB	'$'
REPEATCMND	CALL	SETUP
	CALL	GPARM
	STA	RPEAT
	LXI	D,MESSE
	JMP	REPLY
MESSE	DB	'REPEAT COUNT ACCEPTED'
	DB	'$'
LINECMND	CALL	SETUP
	CALL	GPARM
	STA	LINES
	LXI	D,MESSF
	JMP	REPLY
MESSF	DB	'CHAR/LINE CHANGED'
	DB	'$'
SPACECMND	CALL	SETUP
	CALL	GPARM
	STA	SPACE
	LXI	D,MESSG
	JMP	REPLY
MESSG	DB	'SPACING CHANGED'
	DB	'$'
UNITCMND	CALL	SETUP
	MOV	A,M
	CPI	'L'
	JZ	UNIT1
	CPI	6CH	;LOWER CASE L
	JZ	UNIT1
	CPI	63H	;LOWER CASE C
	JZ	CONUNIT
	CPI 	'C'
	JNZ	ERR2
CONUNIT	EQU	$
	MVI	A,CONSOLE
	JMP	UNIT5
UNIT1	MVI	A,PRINTER
UNIT5	STA	UNIT
	LXI	D,MESS7
	JMP	REPLY
MESS7	DB	'PRINT DEVICE CHANGED'
	DB	'$'
PAGECMND	CALL	SETUP
	CALL	GPARM
	ORA	A
	JZ	ERR2
	STA	PAGE1
	CALL	GPARM
	ORA	A
	JZ	OK1
	STA	PAGE2
	CALL	GPARM
	ORA	A
	JZ	OK1
	STA	PAGE3
OK1	LXI	D,MESS8
	JMP	REPLY
MESS8	DB	'PAGE PARMS CHANGED'
	DB	'$'
TITLECMND	CALL	SETUP
	MVI	B,50
	LXI	D,TITLEX
TTITL0	MOV	A,M
	CPI	' '
	JNZ	TTITL1
	INX	H
	JMP	TTITL0
TTITL1	MOV	A,M
	STAX	D
	CPI	13
	JZ	TTITL2
	INX	H
	INX	D
	DCR	B
	JNZ	TTITL1
	LXI	D,MESSA
	JMP	REPLY
MESSA	DB	'TITLE TOO LONG'
	DB	'$'
TTITL2	LXI	D,MESS9
	JMP	REPLY
MESS9	DB	'TITLE ACCEPTED'
	DB	'$'
;	GET	1 PARAMETER
GPARM	PUSH	B
	PUSH	D
	XRA	A
	STA	SAVE
GPRM2	MOV	A,M
	CPI	13
	JZ	PEOF
	CPI	','
	JZ	PARAM0
	CPI	' '
	JNZ	PARAM1
PARAM0	INX	H
	JMP	GPRM2
PARAM1	EQU	$
	CPI	'0'
	JC	ERR3
	CPI	'9'+1
	JNC	ERR3
	ANI	0FH
	MOV	E,A
	LDA	SAVE
	MOV	B,A
	RLC
	RLC
	RLC
	ADD	B
	ADD	B
	ADD	E
	STA	SAVE
	INX	H
	MOV	A,M
	CPI	13
	JZ	PEOF
	CPI	','
	JZ	PEOF3
	CPI	' '
	JZ	PEOF3
	JMP	PARAM1
PEOF3	INX	H
PEOF	LDA	SAVE
	POP	D
	POP	B
	RET
FINDCMND	CALL	CRLF
	CALL	SETUP
	XRA	A
	STA	CNTR
FIND1	MVI	A,13
	CMP	M
	JZ	ERR2
	MVI	A,' '
	CMP	M
	JNZ	FIND2
	INX	H
	JMP	FIND1
FIND2	SHLD	ADDR1
	LHLD	BOFP
	INX	H
FINDX	SHLD	ADDR2
	INX	H
	INX	H
	INX	H
	INX	H
	SHLD	ADDR3
	XCHG
	LHLD	ADDR1
	XCHG
FIND3	LDAX	D
	CPI	13
	JZ	FOUND
	CMP	M
	JNZ	NOTFD
	INX	H
	INX	D
	JMP	FIND3
NOTFD	LHLD	ADDR1
	XCHG
	LHLD	ADDR3
	INX	H
	SHLD	ADDR3
	MVI	A,13
	CMP	M
	JNZ	FIND3
EOFLN	INX	H
	MVI	A,1
	CMP	M
	JZ	FINI
	CALL	CONTC
	JZ	EOR
	INX	H
	JMP	FINDX
FOUND	LHLD	ADDR2
	LDA	CNTR
	INR	A
	STA	CNTR
FIND5	MOV	A,M
	CPI	13
	JZ	FIND4
	MOV	B,A
	CALL	OUT8A
	INX	H
	JMP	FIND5
FIND4	CALL	OUTCR
	JMP	EOFLN
FINI	LDA	CNTR
	ORA	A
	JNZ	EOR
	LXI	D,MESSC
	JMP	REPLY
MESSC	DB	'CHAR NOT FOUND'
	DB	'$'
OPENCMND	CALL	RANGE
	MVI	A,1
OPEN2	STA	TEMP
	LXI	H,0100H
	SHLD	INCR
	CALL	VCHK
	LXI	H,LINE1
	LXI	D,ABUF+4
	CALL	PACK
	LHLD	LINE1
	SHLD	TBUF
	LXI	H,INCR
	LDAX	D
	CPI	0
	CNZ	PACK
	LHLD	LINE1
	SHLD	TEMP2
	CALL	LFIND
OPEN3	CALL	RNUMB
	MVI	C,4
OPEN4	INX	H
	DCR	C
	JNZ	OPEN4
OPEN5	INX	H
	MVI	A,0DH
	CMP	M
	JNZ	OPEN5
	INX	H
	MVI	A,1
	CMP	M
	JNZ	OPEN3
	LDA	TEMP
	ORA	A
	JZ	CFREE
	XRA	A
	JMP	OPEN2
CFREE	CALL	FREE
	JMP	EOR
RENUMBER	MVI	A,1
RECAL	STA	TEMP
	LXI	H,0500H
	SHLD	INCR
	CALL	VCHK
	LXI	H,LINE1
	LXI	D,ABUF
	CALL	PACK
	LXI	H,INCR
	LDAX	D
	CPI	0
	CNZ	PACK
	LHLD	LINE1
	SHLD	TEMP2
	LHLD	BOFP
NXLIN	CALL	RNUMB
	MVI	C,4
NUM1	INX	H
	DCR	C
	JNZ	NUM1
ALPHA	INX	H
	MVI	A,0DH
	CMP	M
	JNZ	ALPHA
	INX	H
	MVI	A,1
	CMP	M
	JNZ	NXLIN
	LDA	TEMP
	ORA	A
	JZ	CFREE
	XRA	A
	JMP	RECAL
RNUMB	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,2
	LXI	H,NUMBR
	LXI	D,LINE1
CVRT	LDAX	D
	RRC
	RRC
	RRC
	RRC
	CALL	NGEN
	LDAX	D
	CALL	NGEN
	INX	D
	DCR	C
	JNZ	CVRT
	LDA	TEMP
	ORA	A
	JNZ	NOMOV
	POP	H
	PUSH	H
	MVI	C,4
	LXI	D,NUMBR-1
CVRT1	INX	D
	INX	H
	LDAX	D
	MOV	M,A
	DCR	C
	JNZ	CVRT1
	LXI	H,MAXL
	MVI	C,4
	LXI	D,NUMBR
CVRT2	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCR	C
	JNZ	CVRT2
NOMOV	LXI	D,LINE1+1
	LXI	H,INCR+1
	XRA	A
	LDAX	D
	ADC	M
	DAA
	STAX	D
	DCX	D
	DCX	H
	LDAX	D
	ADC	M
	DAA
	STAX	D
	LDA	TEMP2
	MOV	B,A
	LDA	LINE1
	CMP	B
	JC	TOBIG
	LHLD	LINE1
	SHLD	TEMP2
	POP	H
	POP	D
	POP	B
	RET
TOBIG	LXI	D,ERRM7
	JMP	REPLY
ERRM7	DB	'RENUMBER VALUES TOO BIG'
	DB	'$'
NGEN	ANI	0FH
	ADI	'0'
	MOV	M,A
	INX	H
	RET
TABSCMND	LXI	H,TABT
	MVI	B,10
	XRA	A
TAB6X	MOV	M,A
	INX	H
	DCR	B
	JNZ	TAB6X
	CALL	SETUP
TAB1	LXI	D,TABT
	MVI	B,10
TAB5X	PUSH	B
	CALL	GPARM
	STAX	D
	INX	D
	POP	B
	DCR	B
	JZ	TAB4
	MOV	A,M
	CPI	13
	JNZ	TAB5X
TAB4	LXI	D,ERRM8A
	JMP	REPLY
ERRM8A	DB	'TABS SET'
	DB	'$'
PRINTCMND	CALL	CRLF
	LHLD	BOFP
	MOV	A,M
	CPI	1
	JZ	STPIT
	MVI	A,1
	STA	LOMRG
	LDA	LINES
	STA	HIMRG
	STA	CCNT
	CALL	STADD
PRNT1	CALL	FIND
	XRA	A
	STA	JUSTY
	STA	ULFLG
	STA	HALT
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	MVI	A,13
	STA	HL
	CALL	CMNDS
	LDA	PNO
	STA	TEMP+1
PRUN	XRA	A
	MOV	C,A
	STA	CNTR
	STA	TEMP
	LDA	TEMP+1
	INR	A
	STA	TEMP+1
	JZ	SKIP1
	CPI	250
	JC	MOVE1
	DCR	A
	STA	TEMP+1
MOVE1	CALL	MOVIT
	LDA	TITLEX
	ORA	A
	JZ	PPG1
	LXI	D,TITLEX
	CALL	PRNTR
	LDA	TEMP+1
	ORA	A
	JZ	NOTTL
	LDA	TEMP+1
	CPI	250
	JNC	NOTTL
PPG1	LDA	LINES
	SBI	8
	CMP	C
	JC	PPG2
	JZ	PPG2
	MVI	B,' '
	CALL	OUT8A
	INR	C
	JMP	PPG1
PPG2	LDA	TEMP+1
	CPI	250
	JNC	NOTTL
	PUSH	H
	LXI	H,PN2
	CALL	BIND
	POP	H
	LXI	D,PN2
	LDAX	D
	CPI	'0'
	JNZ	PPG3
	INX	D
	LDAX	D
	CPI	'0'
	JNZ	PPG3
	INX	D
PPG3	CALL	PRNTR
	JMP	NOTTL
	DB	0CDH
SKIP1	INR	A
	STA	TEMP+1
NOTTL	CALL	PCRLF
	LDA	CNTR
	INR	A
	STA	CNTR
	MOV	B,A
	LDA	PAGE3
	CMP	B
	JZ	PBODY
	JC	PBODY
	JMP	NOTTL
PBODY	CALL	FORMT
	DCX	H
	MOV	A,M
	INX	H
	CPI	'\'
	JZ	EJECT
PB1	LXI	D,TBUF
CALL4	CALL	MOVIT
	CALL	PRNTR
PB2	CALL	PCRLF
	LDA	CNTR
	INR	A
	STA	CNTR
	LDA	TEMP
	INR	A
	STA	TEMP
	MOV	B,A
	LDA	PAGE2
	CMP	B
	JZ	FULL
	LDA	CNTR
	MOV	B,A
	LDA	PAGE1
	CMP	B
	JZ	FULL
	LDA	SPACE
	ORA	A
	JZ	NOTFL
	MOV	C,A
BLKLN	DCR	C
	JZ	NOTFL
	CALL	PCRLF
	LDA	CNTR
	INR	A
	STA	CNTR
	LDA	TEMP
	INR	A
	STA	TEMP
	MOV	B,A
	LDA	PAGE2
	CMP	B
	JZ	FULL
	LDA	CNTR
	MOV	B,A
	LDA	PAGE1
	CMP	B
	JZ	FULL
	JMP	BLKLN
NOTFL	CALL	CONTC
	JZ	RTRN
	MVI	A,1
	CMP	M
	JZ	FULL
	JMP	PBODY
EJECT	MOV	A,M
	CPI	13
	JZ	FULL
TRY	CPI	'0'
	JC	BAD
	CPI	'9'+1
	JC	GOOD
BAD	CPI	13
	JZ	FULL
	INX	H
	MOV	A,M
	JMP	TRY
GOOD	CALL	NUMB
GOOD1	MOV	A,M
	CPI	13
	JZ	GOOD2
	INX	H
	JMP	GOOD1
GOOD2	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	MVI	A,3
	STA	HL
	CALL	CMNDS
	LDA	TEMP
	ADD	B
	MOV	B,A
	LDA	PAGE2
	CMP	B
	JNC	PBODY
	JZ	PBODY
FULL	LDA	CNTR
	MOV	B,A
	LDA	PAGE1
	CMP	B
	JZ	CKEOF
	CALL	PCRLF
	LDA	CNTR
	INR	A
	STA	CNTR
	JMP	FULL
	DB	0C3H
CKEOF	MVI	A,1
	CMP	M
	JNZ	HALT1
	LDA	INSRT
	ORA	A
	CNZ	FLUSH
	LDA	RPEAT
	ORA	A
	JZ	RTRN
	CPI	1
	JZ	RTRN
	DCR	A
	STA	RPEAT
	CALL	PAUSE
	JMP	PRNT1
RTRN	XRA	A
	STA	SPACE
	CALL	EOFBA
STPIT	MVI	A,CONSOLE
	STA	UNIT
	JMP	EOR
HALT1	CALL	PAUSE
	JMP	PRUN
PCRLF	CALL	CONTC
	JZ	RTRN
	MVI	B,13
	CALL	OUT8A
	MVI	B,10
	CALL	OUT8A
	PUSH	D
	LDA	UNIT
	CPI	CONSOLE
	JNZ	NOSTP
	LDA	SRCNT
	ORA	A
	JZ	NOSTP
	LDA	HALT
	INR	A
	STA	HALT
	MOV	D,A
	LDA	SRCNT
	CMP	D
	JC	PT3
	JNZ	NOSTP
PT3	LXI	D,MESS5
PT1	LDAX	D
	CPI	'$'
	JZ	PT2
	MOV	B,A
	CALL	OUT8A
	INX	D
	JMP	PT1
PT2	CALL	IN8
	CPI	03
	JZ	STPIT
	CPI	13
	JNZ	PT2
	XRA	A
	STA	HALT
	MVI	B,13
	CALL	OUT8A
	MVI	B,10
	CALL	OUT8A
NOSTP	LDA	NULLC
	ORA	A
	JZ	PCRL2
	MOV	E,A
PCRL1	MVI	B,0
	CALL	OUT8A
	DCR	E
	JNZ	PCRL1
PCRL2	POP	D
	RET
FORMT	XRA	A
	STA	NCHR
	STA	SAVE
	STA	TBCNT
FORM1	XCHG
	LXI	H,TABT
	SHLD	TABAD
	LHLD	TADD
	XCHG
FORM2	MOV	A,M
	INX	H
	CPI	'>'
	JZ	MARG
	CPI	'['
	JZ	JON
	CPI	']'
	JZ	JOFF
	CPI	'<'
	JZ	CON
	CPI	'^'
	JZ	INSR1
	CPI	13
	JZ	NEWLN
	CPI	'\'
	JZ	EOF2
	CPI	09
	JZ	TABEX
	CPI	7EH	;TILDE-PAUSE
	JZ	YOUIN
	CPI	'.'
	JZ	EOFS
	CPI	'&'
	JNZ	FORM3
	CALL	SETUL
	DCX	D
	LDAX	D
	CPI	' '
	JNZ	FL1
	MOV	A,M
	CPI	' '
	JNZ	FL1
	JMP	FORM4
FL1	INX	D
	JMP	FORM2
FORM4	INX	D
	MVI	A,'&'
FORM3	STAX	D
	LDA	ULFLG
	ORA	A
	JZ	FORM5
	LDAX	D
	CPI	' '
	JZ	FORM5
	ORI	80H
	STAX	D
FORM5	INX	D
	LDA	NCHR
	INR	A
	STA	NCHR
	MOV	B,A
	CALL	SAVER
	LDA	JUSTY
	ORA	A
	JZ	FORM2
	LDA	CCNT
	CMP	B
	JZ	FILLNX
	JMP	FORM2
EOFS	MOV	A,M
	CPI	13
	JNZ	NEOFS
	MVI	A,'.'
	STAX	D
	INX	D
	LDA	NCHR
	INR	A
	STA	NCHR
	MOV	B,A
	LDA	JUSTY
	ORA	A
	JZ	EOFS1
	LDA	CCNT
	CMP	B
	JZ	FILLNX
EOFS1	MVI	A,' '
	JMP	FORM3
NEOFS	MVI	A,'.'
	JMP	FORM3
SETUL	MOV	A,M
	CPI	13
	JZ	OFFUL
	CPI	' '
	JNZ	ONUL
OFFUL	XRA	A
	JMP	STAUL
ONUL	MVI	A,1
STAUL	STA	ULFLG
	RET
MARG	MOV	A,M
	CPI	13
	JNZ	SETMG
	MVI	A,1
	STA	LOMRG
	LDA	LINES
	STA	HIMRG
	STA	CCNT
	CALL	STADD
	INX	H
	JMP	NXTLN
	DB	3AH
;SET	MARGINS
SETMG	EQU	$
	CALL	NUMB
	MOV	A,B
	ORA	A
	JZ	MAR1
	STA	LOMRG
	LDA	LINES
	CMP	B
	JC	ERRMG
	MOV	A,M
	CPI	13
	JZ	MAR2
	INX	H
	JMP	MAR3
MAR1	INX	H
	MVI	A,1
	STA	LOMRG
	JMP	MAR3
MAR2	LDA	LINES
	JMP	MAR5
MAR6	LDA	LINES
	JMP	MAR5
MAR3	CALL	NUMB
MAR4	MOV	A,B
	ORA	A
	JZ	MAR6
MAR5	STA	HIMRG
	LDA	LOMRG
	MOV	B,A
	LDA	HIMRG
	SUB	B
	JC	ERRMG
	INR	A
	STA	CCNT
	LXI	D,TBUF
	MVI	B,133
	MVI	A,' '
CLR	STAX	D
	INX	D
	DCR	B
	JNZ	CLR
	CALL	STADD
	INX	H
NXTLN	MOV	A,M
	CPI	1
	JZ	EOF2
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	MVI	A,3
	STA	HL
	CALL	CMNDS
	JMP	FORM2
ERRMG	LXI	D,ERRM4
	JMP	REPLY
ERRM4	DB	'MARGIN ERROR'
	DB	'$'
PATCH	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ;PATCH AREA FOR FUTURE
		                                    ;MODS
NUMB	XRA	A
	MOV	B,A
NUMB2	MOV	A,M
	CPI	13
	RZ
	CPI	','
	RZ
	CPI	' '
	RZ
	CPI	'0'
	JC	ERR3
	CPI	'9'+1
	JNC	ERR3
	ANI	0FH
	MOV	C,A
	MOV	A,B
	RLC
	RLC
	RLC
	ADD	B
	ADD	B
	ADD	C
	MOV	B,A
	INX	H
	JMP	NUMB2
STADD	EQU	$
	LXI	D,TBUF
	LDA	LOMRG
	DCR	A
	ADD	E
	MOV	E,A
	JNC	STAD1
	MOV	A,D
	INR	A
	MOV	D,A
STAD1	XCHG
	SHLD	TADD
	XCHG
	RET
	DB	0CDH
;TAB	EXPANSION
TABEX	PUSH	H
	LHLD	TABAD
TABX1	MOV	A,M
	ORA	A
	JZ	TAB99
	LDA	TBCNT
	CPI	10
	JZ	TAB99
	INR	A
	STA	TBCNT
TABX3	LDA	NCHR
	MOV	B,A
	LDA	LOMRG
	ADD	B
	MOV	C,A ;TRUE POSITION
	MOV	A,M ;TAB POSITION
	CMP	C
	JZ	TAB98
	JNC	TABX2
	INX	H
	JMP	TABX1
TABX2	MVI	A,' '
	STAX	D
	INX	D
	LDA	NCHR
	INR	A
	STA	NCHR
	MOV	B,A
	LDA	CCNT
	CMP	B
	JZ	TAB98
	JC	TAB98
	JMP	TABX3
	DB	0CAH
TAB98	INX	H
TAB99	SHLD	TABAD
	POP	H
	JMP	FORM2
INSR1	LDA	INSRT
	ORA	A
	JNZ	INSR2
	MVI	A,'^'
	JMP	FORM3
INSR2	CALL	MOVBA
	JMP	FORM2
	DB	3AH
;	LINE	FILL
SAVER	MOV	A,M
	CPI	' '
	RNZ
	SHLD	ADDR1
	XCHG
	SHLD	ADDR2
	XCHG
	LDA	NCHR
	STA	ADDR4
	RET
FILLNX	EQU	$
	MVI	A,13
	STAX	D
FILL2X	LHLD	ADDR2
	XCHG
	LDA	ADDR4
	STA	NCHR
BKUP	DCX	D
	LDA	NCHR
	DCR	A
	STA	NCHR
	LDAX	D
	CPI	' '
	JZ	BKUP
NOBU	LDA	JUSTY
	ORA	A
	CNZ	JSTFY
	LHLD	ADDR1
BLKCK	MOV	A,M
	INX	H
	CPI	' '
	JZ	BLKCK
	INX	D
	DCX	H
	JMP	EOF2
;JUSTIFICATION	ROUTINE
JSTFY	LDA	SAVE
	ORA	A
	RNZ
	LDA	JSW
	ORA	A
	RZ
	PUSH	H
	PUSH	B
	LDA	NCHR
	INR	A
	STA	NCHR
	MOV	B,A
	LDA	CCNT
	CMP	B
	JZ	JEND
	JC	JEND
	MVI	A,13
	INX	D
	STAX	D
	XCHG
	LHLD	TADD
	XCHG
INDT1	LDAX	D
	CPI	' '
	JNZ	BLTWO
	INX	D
	JMP	INDT1
;ADD	1	BLANK WHERE 2 OR MORE OCCUR
BLTWO	LDAX	D
	CPI	13
	JZ	ODD
	CPI	' '
	JNZ	ONLY1
	INX	D
	LDAX	D
	CPI	13
	JZ	ODD
	CPI	' '
	JNZ	ONLY1
	CALL	BLINS
	LDA	NCHR
	MOV	C,A
	LDA	CCNT
	CMP	C
	JZ	JEND
	JC	JEND
ONLY1	INX	D
	JMP	BLTWO
	DB	0CDH
;EXTRA	BLANK	EVERY OTHER ONE
ODD	XCHG
	LHLD	TADD
	XCHG
	XRA	A
	STA	INSP
ODD2	LDAX	D
	CPI	' '
	JNZ	ODD3
	INX	D
	JMP	ODD2
ODD3	LDAX	D
	CPI	13
	JZ	REBLK
	CPI	' '
	JNZ	ODD4
	LDA	INSP
	ORA	A
	JZ	ODD5
	XRA	A
	STA	INSP
	CALL	BLINS
	LDA	NCHR
	MOV	C,A
	LDA	CCNT
	CMP	C
	JZ	JEND
	JC	JEND
ODD4	INX	D
	JMP	ODD3
ODD5	MVI	A,1
	STA	INSP
	JMP	ODD4
	DB	0CAH
;ADD	BLANK	TO EVEN SPACES
REBLK	XCHG
	LHLD	TADD
	XCHG
INDT2	LDAX	D
	CPI	' '
	JNZ	BLONE
	INX	D
	JMP	INDT2
BLONE	LDAX	D
	CPI	13
	JZ	REBLK
	CPI	' '
	JNZ	NOBLK
	CALL	BLINS
	LDA	NCHR
	MOV	C,A
	LDA	CCNT
	CMP	C
	JZ	JEND
	JC	JEND
NOBLK	INX	D
	JMP	BLONE
JEND	POP	B
	POP	H
	XCHG
	LHLD	TADD
	XCHG
JEND2	LDAX	D
	CPI	13
	RZ
	INX	D
	JMP	JEND2
;	BLANK	INSERT
BLINS	PUSH	H
	PUSH	B
	LXI	B,TBUF+130
	LXI	H,TBUF+131
BLIN1	LDAX	B
	MOV	M,A
	MOV	A,D
	CMP	B
	JNZ	BLIN3
	MOV	A,E
	CMP	C
	JZ	BLIN2
BLIN3	DCX	B
	DCX	H
	JMP	BLIN1
BLIN2	MVI	A,' '
	STAX	D
	LDA	NCHR
	INR	A
	STA	NCHR
BLIN4	INX	D
	LDAX	D
	CPI	' '
	JZ	BLIN4
	POP	B
	POP	H
	RET
YOUIN	CALL	IN8
	CPI	03
	JZ	STPIT
X5F3	CPI	08
	JZ	BACKYOU
	CPI	13
	JZ	CKK
	STAX	D
	MOV	B,A
	INX	D
	LDA	UNIT
	CPI	CONSOLE
	JZ	SKIP2
	CALL	OUT8
SKIP2	LDA	NCHR
	INR	A
	STA	NCHR
	MOV	B,A
	LDA	CCNT
	CMP	B
	JZ	CKK
	JC	CKK
	JMP	YOUIN
BACKYOU	LDA	NCHR
	ORA	A
	JZ	YOUIN
	DCR	A
	STA	NCHR
	DCX	D
	LDA	X5F3+1
	CALL	OUT8
	JMP	YOUIN
CKK	JMP	FORM2
JON	MVI	C,1
	JMP	JOFF+1
JOFF	XRA	A
	STA	JUSTY
	JMP	FORM2
NEWLN	MOV	A,M
	CPI	1
	JZ	EOF2
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	LDA	JUSTY
	ORA	A
	JZ	EOF2
	SHLD	ADDR1
	XCHG
	SHLD	ADDR2
	XCHG
	LDA	NCHR
	STA	ADDR4
	MVI	A,' '
	JMP	FORM3
EOF2	MVI	A,13
	STAX	D
	MVI	A,3
	STA	HL
	CALL	CMNDS
	RET
PRNTR	PUSH	D
	PUSH	H
	XCHG
	SHLD	HL
	XRA	A
	MOV	C,A
	MOV	D,A
	LDA	BSCR
	CPI	'B'
	JZ	PRNT7
PRNT0	MOV	A,M
	CPI	13
	JZ	PRNT4
	ANI	80H
	JZ	PRNT2
	INR	D
	MOV	A,M
	ANI	7FH
	JMP	PRNT3
PRNT2	MOV	A,M
PRNT3	MOV	B,A
	CALL	OUT8A
	INR	C
	INX	H
	JMP	PRNT0
PRNT4	MOV	A,D
	ORA	A
	JZ	PRNT9
	MVI	B,0DH
	CALL	OUT8A
	PUSH	B
	CALL	MOVIT
	POP	B
	LHLD	HL
PRNT5	MOV	A,M
	CPI	13
	JZ	PRNT9
	ANI	80H
	JZ	PRNT6
	MVI	B,'_'
	CALL	OUT8A
	INX	H
	DCR	D
	JZ	PRNT9
	JMP	PRNT5
PRNT6	MVI	B,' '
	CALL	OUT8A
	INX	H
	JMP	PRNT5
PRNT7	MOV	A,M
	CPI	13
	JZ	PRNT9
	ANI	80H
	JNZ	PRNT8
	MOV	A,M
	MOV	B,A
PRNTA	CALL	OUT8A
	INR	C
	INX	H
	JMP	PRNT7
PRNT8	MOV	A,M
	ANI	7FH
	MOV	B,A
	CALL	OUT8A
	MVI	B,08
	CALL	OUT8A
	MVI	B,5FH
	JMP	PRNTA
PRNT9	POP	H
	POP	D
	RET
CKJ	INX	H
	MVI	A,1
	STA	SAVE
	CALL	FORM1
	JMP	PB1
;CENTER	TITLEX
	DB	0CDH
CON	PUSH	B
	XRA	A
	MOV	C,A
	LXI	D,TBUF
CPY	MOV	A,M
	INX	H
	CPI	'&'
	JNZ	CEN2
	CALL	SETUL
	DCX	D
	LDAX	D
	CPI	' '
	JNZ	CEN4
	MOV	A,M
	CPI	' '
	JNZ	CEN4
	JMP	CEN1
CEN4	INX	D
	JMP	CPY
CEN1	INX	D
	MVI	A,'&'
CEN2	CPI	13
	JZ	CENT
	STAX	D
	LDA	ULFLG
	ORA	A
	JZ	CEN3
	LDAX	D
	CPI	' '
	JZ	CEN3
	ORI	80H
	STAX	D
CEN3	INX	D
	INR	C
	MOV	B,C
	LDA	LINES
	CMP	B
	JNC	CPY
	JZ	DON2
	POP	B
	LXI	D,ERRM3
	JMP	REPLY
ERRM3	DB	'LINE TOO SMALL TO CENTER'
	DB	'$'
	DB	03AH
CENT	MVI	A,13
	STAX	D
	XCHG
	SHLD	ADDR1
	XCHG
	INR	C
	MOV	A,C
	STA	NCHR
	MOV	B,A
	LDA	LINES
	SUB	B
	RRC
	ANI	07FH
	INR	A
	MOV	B,A
	PUSH	H
LOOP4	LHLD	ADDR1
	XCHG
	LHLD	ADDR1
	INX	H
	SHLD	ADDR1
	LDA	NCHR
	MOV	C,A
LOOP3	LDAX	D
	MOV	M,A
	MVI	A,' '
	STAX	D
	DCX	H
	DCX	D
	DCR	C
	JNZ	LOOP3
	DCR	B
	JNZ	LOOP4
	LHLD	ADDR1
	XCHG
	POP	H
DON2	POP	B
	JMP	NEWLN
;PAGE	NO	TO DBII
BIND	MVI	B,100
	CALL	BID1
	MVI	B,10
	CALL	BID1
	ADI	'0'
	MOV	M,A
	RET
BID1	MVI	M,'0'-1
	INR	M
	SUB	B
	JNC	BID1+2
	ADD	B
	INX	H
	RET
PN2	DB	'000'
	DB	13
PAUSE	LDA	STOP
	ORA	A
	RZ
PAZ	CALL	IN8
	CPI	13
	JNZ	PAZ
	RET
MOVIT	LDA	OFFST
	ORA	A
	RZ
	MOV	C,A
	MVI	B,' '
SHIFTX	CALL	OUT8A
	DCR	C
	JNZ	SHIFTX
	RET
CMNDS	PUSH	D
CMND2	MOV	A,M
	CPI	'#'
	JNZ	RETRN
	SHLD	ADDR1
	LXI	D,IBUF
	INX	H
UPPER	MOV	A,M
	STAX	D
	INX	D
	INX	H
	CPI	13
	JZ	SCAN
	JMP	UPPER
SCAN	SHLD	DE
	MVI	B,4
	LXI	D,IBUF
SCAN2	LDAX	D
	CPI	60H
	JC	SCAN3
	SBI	20H
	STAX	D
SCAN3	INX	D
	DCR	B
	JNZ	SCAN2
	LXI	D,CTABX
	LDA	HL
	MOV	B,A
	MVI	A,4
	STA	NCHR
	CALL	COMS
	JNZ	ERR1
	PCHL
NOGO	LHLD	ADDR1
RETRN	POP	D
	RET
CTABX	DB	'SPAC'
	DW	SPAC2
	DB	'COMM'
	DW	COMNT
	DB	'CHAI'
	DW	CHAINR
	DB	'NULL'
	DW	NULL1
	DB	'TITL'
	DW	TITL1
	DB	'LINE'
	DW	LINE2
	DB	'DEVI'
	DW	UNIT2
	DB	'PAGE'
	DW	PAGEZ
	DB	'JUST'
	DW	JUSTZ
	DB	'TABS'
	DW	TABSZ
	DB	'OFFS'
	DW	OFF2
	DB	'PNUM'
	DW	PNUM2
	DB	'MARG'
	DW	MARG1
MARG1	CALL	SETUP
	CALL	NUMB
	MOV	A,B
	ORA	A
	JZ	ERR1
	DCR	A
	STA	OFFST
	INX	H
	CALL	NUMB
	MOV	A,B
	ORA	A
	JZ	ERR1
	MOV	C,A
	LDA	OFFST
	MOV	B,A
	MOV	A,C
	SUB	B
	JC	ERR1
	STA	LINES
	STA	HIMRG
	STA	CCNT
	JMP	SKIP3
COMNT	CALL	SETUP
	JMP	SKIP3
NULL1	CALL	SETUP
	CALL	NUMB
	MOV	A,B
	STA	NULLC
	JMP	SKIP3
LINE2	CALL	SETUP
	CALL	NUMB
	MOV	A,B
	STA	LINES
	STA	HIMRG
	STA	CCNT
	JMP	SKIP3
SPAC2	CALL	SETUP
	CALL	NUMB
	MOV	A,B
	STA	SPACE
	JMP	SKIP3
UNIT2	CALL	SETUP
	MOV	A,M
	CPI	'L'
	JZ	UNIT3
	CPI	6CH	;LOWER CASE L
	JZ	UNIT3
	CPI	63H	;LOWER CASE C
	JZ	CONUNITC
	CPI	'C'
	JNZ	ERR2
CONUNITC EQU	$
	MVI	A,CONSOLE
	JMP	UNIT4
UNIT3	MVI	A,PRINTER
UNIT4	STA	UNIT
	JMP	SKIP3
OFF2	CALL	SETUP
	CALL	NUMB
	MOV	A,B
	STA	OFFST
	JMP	SKIP3
PNUM2	CALL	SETUP
	CALL	NUMB
	MOV	A,B
	DCR	A
	STA	PNO
	JMP	SKIP3
JUSTZ	CALL	SETUP
	CALL	ONOFF
	MOV	A,B
	STA	JSW
	JMP	SKIP3
PAGEZ	CALL	SETUP
	CALL	NUMB
	MOV	A,B
	STA	PAGE1
	MOV	A,M
	CPI	13
	JZ	SKIP3
	INX	H
	CALL	NUMB
	MOV	A,B
	STA	PAGE2
	MOV	A,M
	CPI	13
	JZ	SKIP3
	INX	H
	CALL	NUMB
	MOV	A,B
	STA	PAGE3
	JMP	SKIP3
TITL1	CALL	SETUP
	LXI	D,TITLEX
	MVI	B,50
TITL3	MOV	A,M
	STAX	D
	CPI	13
	JZ	SKIP3
	INX	H
	INX	D
	DCR	B
	JNZ	TITL3
	LXI	D,MSG5
	JMP	REPLY
MSG5	DB	'TITLE TOO LONG'
	DB	'$'
CHAINR	LHLD	BOFP
	SHLD	BOUND
	CALL	LOADR
	LHLD	BOFP
	LXI	SP,AREA+50
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	LDA	TEMP+1
	STA	PNO
	MVI	A,13
	STA	HL
	CALL	CMNDS
	LDA	PNO
	STA	TEMP+1
	JMP	PB1
TABSZ	CALL	SETUP
	LXI	D,TABT
	MVI	B,10
	XRA	A
TAB6	STAX	D
	INX	D
	DCR	B
	JNZ	TAB6
	LXI	D,TABT
	MVI	B,10
TAB5	PUSH	B
	CALL	NUMB
	MOV	A,B
	STAX	D
	INX	D
	POP	B
	DCR	B
	JZ	SKIP3
	MOV	A,M
	CPI	13
	JZ	SKIP3
	INX	H
	JMP	TAB5
	DB	0CDH
ONOFF	XRA	A
	MOV	B,A
	MOV	A,M
	CPI	13
	RZ
	CPI	'O'
	JZ	ON2
	CPI	6FH
	RNZ
ON2	INX	H
	MOV	A,M
	CPI	'N'
	JZ	ON3
	CPI	6EH
	RNZ
ON3	MVI	B,1
	RET
SKIP3	LHLD	DE
	INX	H
	INX	H
	INX	H
	INX	H
	INX	H
	JMP	CMND2
DIRECTORY	EQU	$	;LIST THE SYSTEM DIRECTORY
	MVI	A,4		;FOUR ENTRIES ACCROSS ON THE SCREEN
	STA	TEMP
	CALL	CRLF
	CALL	SETUP
	MOV	A,M		;SEE IF A DISK LETTER WAS ENTERED
	CPI	13
	JZ	DEFAULT		;NONE ENTERED, USE DEFAULT DRIVE
	CPI	'A'		;CHECK FOR A VALID DRIVE
	JC	ERR2
	CPI	'P'+1
	JNC	ERR2
	STA	DIRENTRY	;STORE LETTER IN THE PRINTED LINE
	ANI	0FH		;A=1...P=15
	STA	DUMMYFCB	;SELECT ENTRIES ON THE RIGHT DRIVE
	JMP	GETFIRST
DEFAULT	MVI	A,20H		;NO DRIVE SPECIFIED
	STA	DIRENTRY
	XRA	A
	STA	DUMMYFCB
GETFIRST	EQU	$	;GET THE FIRST DIRECTORY ENTRY
	LXI	D,TBUF		;SET THE DMA ADDR FOR THE DIRECTORY 
	MVI	C,1AH		;ENTRY TO INTERENAL STORAGE
	CALL	BDOS
	LXI	D,DUMMYFCB	;GET FIRST ENTRY USING THE DUMMYFCB
	MVI	C,11H		;TO GET ALL FILES
	CALL	BDOS
	INR	A
	JZ	DIRECTDONE	;NO MORE FILES
	JMP	FORMFCB
NEXTFCB	LXI	D,DUMMYFCB	;GET THE NEXT ENTRY
	MVI	C,12H
	CALL	BDOS
	INR	A
	JZ	DIRECTDONE
FORMFCB	LXI	D,32		;EACH ENTRY IS 32 BYTES LONG
	LXI	H,TBUF
	CPI	1		;IS NEXT ENTRY THE FIRST ENTRY IN
	JZ	FORMREC		;THE DIRECTORY RECORD?
	DAD	D		;POSITION TO SECOND ONE
	CPI	2		;IS IT THE SECOND ONE
	JZ	FORMREC
	DAD	D		;POSITION TO THIRD ONE
	CPI	3
	JZ	FORMREC
	DAD	D		;MUST BE FOURTH ONE
FORMREC	PUSH	H		;CHECK THE EXTENT NUMBER
	LXI	D,12		;POSITION TO EXTENT
	DAD	D		;POSITION TO EXTENT
	MOV	A,M		;ONLY SAVE ENTRIES WITH THE FIRST EXTENT
	ORA	A		;FIRST ONLY
	JZ	FIRSTEXT
	CPI	1		;DIR CAN ALSO HAVE EXT 1
	JZ	FIRSTEXT
	POP	H
	JMP	NEXTFCB
FIRSTEXT	POP	H	;GET BACK TO FIRST BYTE OF FCB
	LXI	D,DIRENTRY
	INX	H		;POSITION PAST DRIVE NUMBER
	INX	D
	INX	D		;POSITION PAST COLON
	MVI	C,8		;MOVE 8 CHAR IN FILE NAME
FIRST8	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	FIRST8
	INX	D		;POSITION PAST PERIOD
	MVI	C,3		;COPY THE FILE TYPE
NEXT3	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	NEXT3
	LXI	D,DIRENTRY	;PRINT THE DIRECTORY ON CONSOLE
	CALL	SCRN
	LDA	TEMP		;CHECK THE NUMBER OF ENTRIES ON
	DCR	A		;ONE LINE TO SEE IF A NEW LINE
	STA	TEMP		;IS NEEDED
	JNZ	NEXTFCB		;NO
	MVI	A,4		;SETUP NEXT LINE
	STA	TEMP
	CALL	CRLF
	CALL	CONTC		;SEE IF YOU SHOULD ABORT EARLY
	JZ	EOR
	JMP	NEXTFCB
DIRECTDONE	MVI	C,0DH	;RESET DISK SYSTEM
	CALL	BDOS
	CALL	CRLF
	JMP	EOR
DIRENTRY	DS	1
	DB	':'
	DS	8
	DB	'.'
	DS	3
	DB	'  $'
DUMMYFCB	DB	0,'????????????',0,0,0,0,0,0,0,0,0,0,0
	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0
BSAVEMSG	DB	0DH,0AH,'STRIP OFF LINE NUMBERS (Y/N)? $'
BLOADMSG	DB	0DH,0AH,'DO LINE NUMBERS ALREADY EXIST (Y/N)? $'

* CONVERT A CP/M STANDARD FORMATTED FILE INTO SECRTARY FORMAT
* IE TEXT, CR, LF ....TO BYTE COUNT, 4 ASCII DIGIT LINE NUMBER,
* TEXT, CR

BLOAD	CALL	CRLF		;CREATE A SECRTARY FILE
	LHLD	BOFP		;EMPTY THE MEMORY FILE
	SHLD	EOFP
	MVI	M,1
	LXI	H,0000
	SHLD	MAXL
	SHLD	MAXL+2
	CALL	GETFCB
	MVI	C,0FH		;ATTEMPT TO OPEN FILE
	LXI	D,FCB
	CALL	BDOS
	LXI	D,NOFILE	;ERROR IF NOT THERE
	INR	A
	JZ	REPLY		;DMA HAS NOT BEEN SET YET SO NO RESET
BMSG2	LXI	D,BLOADMSG	;ASK IF LINE NUMBERS EXIST
	CALL	SCRN
	CALL	IN8
	STA	SAVE
	MOV	B,A
	CALL	OUT8
	LDA	SAVE
	CPI	'Y'
	JZ	BLOAD1
	CPI	'N'
	JNZ	BMSG2
BLOAD1	CALL	RESETIO		;SET DMA AND COUNTERS
	CALL	READBUFF
	XRA	A		;CLEAR EOF INDICATOR
	STA	DISK
	LXI	H,0500H		;SET STARTING LINE NUMBER AND
	SHLD	INCR		;INCREMENT FOR AUTOMATIC LINE NUMBER
	SHLD	LINE1		;GENERATION
BLOAD3	MVI	C,2		;C=CHAR/LINE INCL CR AND BYTE COUNT
	LXI	H,IBUF		;DESTINATION BUFFER
	LDA	SAVE		;DO LINE NUMBERS ALREADY EXIST?
	CPI	'N'
	JNZ	BLOAD2		;YES, SKIP AUTO GENERATION
	CALL	LNGEN
	MOV	A,C		;INCREMENT CHAR/LINE COUNT
	ADI	4		;BY THE LINE NUMBER CHARACTERS
	MOV	C,A
BLOAD2	CALL	GETCHAR		;COPY THE LINE THRU A CR
	MOV	M,A
	CPI	13
	JZ	ENDOFLINE
	INR	C
	INX	H
	JMP	BLOAD2		;NO CHECK IS MADE FOR MAX LINE SIZE
ENDOFLINE	INX	H	;ADD ONE TO THE ADDR TO GET THE 01
	MVI	M,01
	MOV	A,C		;MOVE IN THE BYTE COUNT
	STA	IBUF-1
	CALL	LINE		;ADD LINE TO THE FILE
	CALL	GETCHAR		;SKIP LINE FEED
	CPI	0AH
	JNZ	FORMATERR	;WAS EXPECTING A LINE FEED
	LDA	DISK		;CHECK EOF
	ORA	A
	JZ	BLOAD3
	CALL	RESETIO		;RESET DMA
	CALL	FINDEND		;FIND END OF FILE
	CALL	FREE		;PRINT STORAGE USAGE
	JMP	EOR
 
GETCHAR	PUSH	H
	LHLD	BUFAD		;GET THE ADDR OF NEXT CHAR
	MOV	A,M
	INX	H		;INCREMENT BUFFER ADDR
	SHLD	BUFAD
	PUSH	PSW		;SAVE INPUT CHARACTER
	LDA	BUFCT		;SEE IF BUFFER IS NOW EMPTY
	DCR	A
	STA	BUFCT
	CZ	READBUFF	;READ IN NEXT BUFFER IF SO
	LHLD	BUFAD		;SEE IF EOF WAS JUST READ
	MOV	A,M		;EOF IS AN 1AH
	CPI	1AH
	JNZ	RETURN
	STA	DISK
RETURN	POP	PSW
	POP	H
	RET
FORMATERR	CALL	RESETIO	;FORMAT OF INPUT FILE WAS WRONG
	LXI	D,FERR
	JMP	REPLY
FERR	DB	'EXPECTED LINE FEED MISSING$'
READBUFF	PUSH	H	;READ NEXT RECORD INTO BUFFER
	PUSH	D
	PUSH	B
	CALL	CLRALL
	LXI	D,FCB
	MVI	C,20		;READ SEQUENTIAL
	CALL	BDOS
	INR	A
	JNZ	RESTORE		;LAST RECORD READ
	MVI	A,1
	STA	DISK		;SET EOF INDICATOR
RESTORE	POP	B		;RESTORE THE ENVIRONMENT
	POP	D
	POP	H
	RET

BSAVE	CALL	CRLF		;CONVERT A SECRTARY FILE TO
	CALL	GETFCB
	MVI	C,0FH		;ATTEMPT TO OPEN
	LXI	D,FCB
	CALL	BDOS
	INR	A
	JZ	BMAKE		;FILE NOT FOUND, CREATE ONE
	LXI	D,FCB		;FILE FOUND, DELETE IT
	MVI	C,13H
	CALL	BDOS
BMAKE	LXI	D,FCB
	MVI	C,16H		;MAKE A NEW FILE
	CALL	BDOS
	LXI	D,DISKFULL	;DISK IS ALREADY FULL
	INR	A
	JZ	REPLY
BMSG1	LXI	D,BSAVEMSG	;ASK ABOUT LINE NUMBERS
	CALL	SCRN		;DO YOU WANT THEM STRIPPED OFF
	CALL	IN8
	STA	SAVE
	MOV	B,A
	CALL	OUT8
	LDA	SAVE
	CPI	'Y'		;SAVE LINE NUMBERS
	JZ	BSAVE1
	CPI	'N'		;STRIP LINE NUMBERS
	JNZ	BMSG1		;BAD RESPONSE
BSAVE1	CALL	RESETIO
	LXI	H,DATA		;BEGINNING OF DATA
COPYLINE	MOV	A,M	;GET CHAR FROM MEMORY
	CPI	01		;IS IT AN END OF FILE
	JZ	BSAVEEND
	LDA	SAVE
	CPI	'N'		;SKIP COPYING THE LINE NUMBERS
	JZ	COPYCHAR
	INX	H
	INX	H
	INX	H
	INX	H
COPYCHAR	INX	H	;COPY THE LINE
	MOV	A,M
	CALL	PUTCHAR		;PUT CHAR INTO BUFFER
	MOV	A,M		;WRITEBUFF MAY WIPE OUT ACC
	CPI	0DH		;CR FOUND
	JNZ	COPYCHAR	;NO, KEEP COPYING
	MVI	A,0AH		;PUT OUT A LINE FEED ALSO
	CALL	PUTCHAR
	INX	H		;POSITION TO CHAR COUNT
	JMP	COPYLINE
BSAVEEND	CALL	WRITEBUFF	; WRITE LAST BUFFER
	JMP	CLOSEIT

RESETIO	MVI	C,0DH		;RESET DISK SYSTEM
	CALL	BDOS
CLRALL	MVI	A,128
	STA	BUFCT
	LXI	H,80H		;BUFFER ADDRESS
	SHLD	BUFAD
	MVI	C,128		;CLEAR BUFFER WITH EOF (1AH)
	MVI	A,1AH		;FOR ENDING THE LAST BUFFER
INITBUFF MOV	M,A		;CLEAR BUFFER
	INX	H
	DCR	C
	JNZ	INITBUFF
	RET

PUTCHAR	PUSH	H		;MOVE CHAR TO THE BUFFER
	LHLD	BUFAD
	MOV	M,A
	INX	H
	SHLD	BUFAD
	LDA	BUFCT
	DCR	A
	STA	BUFCT
	POP	H
	RNZ
WRITEBUFF	PUSH	H	;WRITE ONE BUFFER FULL
	LXI	D,FCB
	MVI	C,15H		;WRITE SEQUENTIAL
	CALL	BDOS
	ORA	A
	JNZ	WRITERR		;DISK FULL
	CALL	CLRALL		;RESET POINTERS/ CLEAR BUFFER
	POP	H
	RET
WRITERR	CALL	RESETIO		;RESET DMA
	LXI	D,DISKFULL	;PUT OUT ERROR MESSAGE
	JMP	REPLY

CONFIGURE	LXI	SP,AREA+50
	CALL	CRLF
	LXI	D,Q1
	CALL	SCRN
	CALL	IN8
	MOV	B,A
	CALL	OUT8
	MOV	E,B
	CALL	CRLF
	MOV	A,E
	CPI	'N'
	JZ	EOR
	CPI	'Y'
	JNZ	CONFIGURE
CNFG2	CALL	CRLF
	MVI	A,'Y'
	STA	FLG1
CNFG3	LXI	D,Q3
	CALL	SCRN
	CALL	IN8
	MOV	B,A
	CALL	OUT8
	MOV	A,B
	STA	BSPCH
	CALL	CRLF
CNFG5	LXI	D,Q5
	CALL	SCRN
	CALL	IN8
	MOV	B,A
	CALL	OUT8
	MOV	A,B
	CPI	'N'
	JZ	CNFGB
	CPI	'Y'
	JZ	CNFGC
	CALL	CRLF
	JMP	CNFG5
CNFGB	XRA	A
	JMP	CNFGC1
CNFGC	MVI	A,1
CNFGC1	STA	STOP
	CALL	CRLF
	LXI	D,Q6
	CALL	SCRN
	CALL	READ
	LXI	H,IBUF
	CALL	GPARM
	ORA	A
	JZ	CNFGC2
	DCR	A
CNFGC2	STA	SRCNT
CNFG8	CALL	CRLF
	LXI	D,Q8
	CALL	SCRN
	CALL	READ
	LXI	H,IBUF
	CALL	GPARM
	CPI	139
	JNC	CNFG8
	ADI	2
	STA	LNSIZ
CNFG7	CALL	CRLF
	LXI	D,Q7
	CALL	SCRN
	CALL	IN8
	MOV	B,A
	STA	WRAP
	CALL	OUT8
	CALL	CRLF
	LDA	WRAP
	CPI	'Y'
	JZ	CNF10
	CPI	'N'
	JZ	CNF10
	JMP	CNFG7
CNF10	LXI	D,Q10X
	CALL	SCRN
	CALL	IN8
	MOV	B,A
	CALL	OUT8
	MOV	A,B
	STA	BSCR
	CALL	CRLF
	LDA	BSCR
	CPI	'B'
	JZ	CNFGD
	CPI	'C'
	JZ	CNFGD
	JMP	CNF10
CNFGD	EQU	$
	MVI	A,'Y'
	STA	FLG1
	LXI	D,Q99X
	CALL	SCRN
	JMP	INITA
Q99X	DB	13,10,10
    	DB	'IF YOU WANT TO SAVE THIS CONFIGURATION,',13,10
	DB	'"QUIT" AND ENTER "SAVE 48 SECRTARY.COM"'
	DB	13,10,10,'$'
Q1	DB	'CONFIGURE (Y/N)? '
	DB	'$'
Q3	DB	'TYPE CHAR USED FOR BACKSPACE'
	DB	'$'
Q5	DB	'STOP AT END OF EACH PAGE (Y/N)? '
	DB	'$'
Q6	DB	'LINES PER SCREEN OR ZERO? '
	DB	'$'
Q7	DB	'LINE WRAP AROUND ON INPUT (Y/N)? '
	DB	'$'
Q8	DB	'INPUT LINE LENGTH? '
	DB	'$'
Q10X	DB	'UNDERLINE USING BS OR CR (B/C)? '
	DB	'$'
; STATUS COMMAND SHOWS ALL USER CHANGABLE INDICATORS
STATCMND	CALL	CRLF
	CALL	CRLF		;BLANK LINE BEFORE DISPLAY
	LXI	D,STAT1		;SCREEN SIZE
	CALL	SCRN
	LDA	SRCNT
	INR	A
	CALL	NUMBER
	LXI	D,STAT2
	CALL	SCRN
	LDA	LNSIZ
	DCR	A		;CONFIGURE ADDS 2
	DCR	A
	CALL	NUMBER
	LXI	D,STAT3		;LINE WRAPAROUND
	CALL	SCRN
	LDA	WRAP
	CALL	ALPHABETIC
	LXI	D,STAT4		;UNDERLINE MODE
	CALL	SCRN
	LDA	BSCR
	CALL	ALPHABETIC
	CALL	CRLF
	LXI	D,STAT5		;STOP AT BOTTOM OF PAGE
	CALL	SCRN
	LDA	STOP
	ORA	A
	JZ	STATUS1
	MVI	A,'Y'
	JMP	STATUS2
STATUS1	MVI	A,'N'
STATUS2	CALL	ALPHABETIC
	LXI	D,STAT7		;NULL COUNT
	CALL	SCRN
	LDA	NULLC
	CALL	NUMBER
	LXI	D,STAT19	;OFFSET
	CALL	SCRN
	LDA	OFFST
	CALL	NUMBER
	LXI	D,STAT12	;SPACE
	CALL	SCRN
	LDA	SPACE
	ORA	A
	JNZ	STATINR
	MVI	A,1
STATINR	EQU	$
	CALL	NUMBER
	CALL	CRLF
	LXI	D,STAT8		;PAGE SIZE
	CALL	SCRN
	LDA	PAGE1
	CALL	NUMBER
	LDA	PAGE2
	CALL	NUMBER
	LDA	PAGE3
	CALL	NUMBER
	LXI	D,STAT9		;MARGINS
	CALL	SCRN
	LDA	OFFST
	INR	A
	CALL	NUMBER
	LDA	OFFST
	MOV	B,A
	LDA	LINES
	ADD	B
	CALL	NUMBER
	LXI	D,STAT10	;OUTPUT LINE LENGTH
	CALL	SCRN
	LDA	LINES
	CALL	NUMBER
	CALL	CRLF
	LXI	D,STAT11	;TAB SETTINGS
	CALL	SCRN
	LXI	D,TABT
	MVI	B,10
	LDAX	D
	ORA	A
	JNZ	STATTAB
	LXI	D,STAT99
	CALL	SCRN
	JMP	STATSPC
STATTAB	CALL	NUMBER
	INX	D
	DCR	B
	JZ	STATSPC
	LDAX	D
	ORA	A
	JNZ	STATTAB
STATSPC	EQU	$
	CALL	CRLF
	LXI	D,STAT13	;TITLE
	CALL	SCRN
	LDA	TITLEX
	ORA	A
	JNZ	STATTTL
	LXI	D,STAT99
	CALL	SCRN
	JMP	STATLN6
STATTTL	LXI	D,TITLEX
	CALL	SCRNCR
STATLN6	CALL	CRLF
	LXI	D,STAT14	;JUSTIFY
	CALL	SCRN
	LDA	JSW
	ORA	A
	JZ	STATJN
	MVI	A,'Y'
	JMP	STATJY
STATJN	MVI	A,'N'
STATJY	CALL	ALPHABETIC
	LXI	D,STAT16	;UNIT
	CALL	SCRN
	LDA	UNIT
	CPI	CONSOLE
	JZ	STATCON
	MVI	A,'L'
	JZ	STATDEV
STATCON	MVI	A,'C'
STATDEV	CALL	ALPHABETIC
	LXI	D,STAT17	;REPEAT
	CALL	SCRN
	LDA	RPEAT
	CALL	NUMBER
	LXI	D,STAT18	;PAGE NUMBER--PNUM
	CALL	SCRN
	LDA	PNO
	INR	A
	CALL	NUMBER
	CALL	FREE		;MEMORY UTILIZATION INFO
	CALL	CRLF
	JMP	EOR
NUMBER	EQU	$
	PUSH	H
	PUSH	D
	PUSH	B
	CALL	PREBLANK
	LXI	H,PN2
	CALL	BIND
	LXI	D,PN2
	LDAX	D
	CPI	'0'		;SKIP LEADING ZEROES
	JNZ	PRTNUMB
	INX	D
	LDAX	D		;SKIP ZEROES
	CPI	'0'
	JNZ	PRTNUMB
	INX	D
PRTNUMB	EQU	$
	CALL	SCRNCR
	POP	B
	POP	D
	POP	H
	RET

PREBLANK	PUSH	PSW		;SAVE A REG
	MVI	B,20H
	CALL	OUT8
	POP	PSW
	RET

ALPHABETIC EQU	$		;PRINT 1 ALPHA CHAR IN A
	CALL	PREBLANK
	MOV	B,A
	JMP	OUT8		;PRINT IT USING OUT8'S RETURN
STAT1	DB	'SCREEN SIZE:','$'
STAT2	DB	' X','$'
STAT3	DB	'   LINE WRAPAROUND:','$'
STAT4	DB	'   UNDERLINE:','$'
STAT5	DB	'STOP AT BOTTOM:','$'
STAT7	DB	'   NULLS:','$'
STAT8	DB	'PAGE SIZE:','$'
STAT9	DB	'   MARGINS:','$'
STAT10	DB	'   OUTPUT LINE:','$'
STAT11	DB	'TABS:','$'
STAT12	DB	'   SPACING:','$'
STAT13	DB	'TITLE: ','$'
STAT14	DB	'JUSTIFY:','$'
STAT16	DB	'   DEVICE:','$'
STAT17	DB	'   REPEAT:','$'
STAT18	DB	'   PNUM:','$'
STAT19	DB	'   OFFSET:','$'
STAT99	DB	' NONE','$'
RAM	EQU	$
AREA	DS	55
DBR	EQU	13
BOFP	DS	2
EOFP	DS	2
TOP	DS	2
MPTY	DS	2
MAXL	DS	4
INSP	DS	2
DELP	EQU	INSP
HCON	DS	2
ADDS	EQU	HCON
FBUF	DS	5
NULLC	DS	1
SPACE	DS	1
LINES	DS	1
PAGE1	DS	1
PAGE2	DS	1
PAGE3	DS	1
FCB	DS	1
FILE	DS	8
FTYPE	DS	3
	DS	24
HTYPE	DS	4
BOUND	DS	2
RWIND	DS	1
DISK	DS	1
LINEA	DS	2
SAVE	DS	1
NUMBR	DS	4
INCR	DS	2
CNTR	DS	1
RPEAT	DS	1
BLKS	DS	1
BLOCK	DS	1
UNIT	DS	1
AUTO	DS	1
JUSTY	DS	1
JSW	DS	1
INSRT	DS	1
CALLC	DS	1
CALLD	DS	2
ABUF	DS	12
BBUF	DS	4
NCHR	DS	1
PNTR	DS	2
LINE1	DS	2
TEMP	DS	2
ADDR1	DS	2
ADDR2	DS	2
ADDR3	DS	2
ADDR4	DS	2
TEMP2	DS	2
TEMP3	DS	2
TITLEX	DS	50
HIMRG	DS	1
LOMRG	DS	1
CCNT	DS	1
TADD	DS	2
TABT	DS	10
TBCNT	DS	1
TABAD	DS	2
OFFST	DS	1
PNO	DS	1
BUFAD	DS	2
LAST	DS	1
BUFCT	DS	2
DSKAD	DS	2
RECCT	DS	1
CUSED	DS	1
INHIB	DS	1
HALT	DS	1
HL	DS	2
DE	DS	2
DBFLG	DS	1
ULFLG	DS	1
IBUF1	DS	1
IBUF	DS	140
TBUF	DS	140
MBUF	DS	128	;MERGE COMMAND DATA BUFFER
MFCB	DS	36	;MERGE COMMAND FCB
DATA	EQU	$
	END	100H
